/*	$NetBSD: bm1880-clock.h,v 1.1.1.1 2020/01/03 14:33:05 skrll Exp $	*/

/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Device Tree binding constants for Bitmain BM1880 SoC
 *
 * Copyright (c) 2019 Linaro Ltd.
 */

#ifndef __DT_BINDINGS_CLOCK_BM1880_H
#define __DT_BINDINGS_CLOCK_BM1880_H

#define BM1880_CLK_OSC			0
#define BM1880_CLK_MPLL			1
#define BM1880_CLK_SPLL			2
#define BM1880_CLK_FPLL			3
#define BM1880_CLK_DDRPLL		4
#define BM1880_CLK_A53			5
#define BM1880_CLK_50M_A53		6
#define BM1880_CLK_AHB_ROM		7
#define BM1880_CLK_AXI_SRAM		8
#define BM1880_CLK_DDR_AXI		9
#define BM1880_CLK_EFUSE		10
#define BM1880_CLK_APB_EFUSE		11
#define BM1880_CLK_AXI5_EMMC		12
#define BM1880_CLK_EMMC			13
#define BM1880_CLK_100K_EMMC		14
#define BM1880_CLK_AXI5_SD		15
#define BM1880_CLK_SD			16
#define BM1880_CLK_100K_SD		17
#define BM1880_CLK_500M_ETH0		18
#define BM1880_CLK_AXI4_ETH0		19
#define BM1880_CLK_500M_ETH1		20
#define BM1880_CLK_AXI4_ETH1		21
#define BM1880_CLK_AXI1_GDMA		22
#define BM1880_CLK_APB_GPIO		23
#define BM1880_CLK_APB_GPIO_INTR	24
#define BM1880_CLK_GPIO_DB		25
#define BM1880_CLK_AXI1_MINER		26
#define BM1880_CLK_AHB_SF		27
#define BM1880_CLK_SDMA_AXI		28
#define BM1880_CLK_SDMA_AUD		29
#define BM1880_CLK_APB_I2C		30
#define BM1880_CLK_APB_WDT		31
#define BM1880_CLK_APB_JPEG		32
#define BM1880_CLK_JPEG_AXI		33
#define BM1880_CLK_AXI5_NF		34
#define BM1880_CLK_APB_NF		35
#define BM1880_CLK_NF			36
#define BM1880_CLK_APB_PWM		37
#define BM1880_CLK_DIV_0_RV		38
#define BM1880_CLK_DIV_1_RV		39
#define BM1880_CLK_MUX_RV		40
#define BM1880_CLK_RV			41
#define BM1880_CLK_APB_SPI		42
#define BM1880_CLK_TPU_AXI		43
#define BM1880_CLK_DIV_UART_500M	44
#define BM1880_CLK_UART_500M		45
#define BM1880_CLK_APB_UART		46
#define BM1880_CLK_APB_I2S		47
#define BM1880_CLK_AXI4_USB		48
#define BM1880_CLK_APB_USB		49
#define BM1880_CLK_125M_USB		50
#define BM1880_CLK_33K_USB		51
#define BM1880_CLK_DIV_12M_USB		52
#define BM1880_CLK_12M_USB		53
#define BM1880_CLK_APB_VIDEO		54
#define BM1880_CLK_VIDEO_AXI		55
#define BM1880_CLK_VPP_AXI		56
#define BM1880_CLK_APB_VPP		57
#define BM1880_CLK_DIV_0_AXI1		58
#define BM1880_CLK_DIV_1_AXI1		59
#define BM1880_CLK_AXI1			60
#define BM1880_CLK_AXI2			61
#define BM1880_CLK_AXI3			62
#define BM1880_CLK_AXI4			63
#define BM1880_CLK_AXI5			64
#define BM1880_CLK_DIV_0_AXI6		65
#define BM1880_CLK_DIV_1_AXI6		66
#define BM1880_CLK_MUX_AXI6		67
#define BM1880_CLK_AXI6			68
#define BM1880_NR_CLKS			69

#endif /* __DT_BINDINGS_CLOCK_BM1880_H */
