/* $NetBSD: sunxi_hdmireg.h,v 1.1 2018/04/03 12:52:16 bouyer Exp $ */

/*-
 * Copyright (c) 2013 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Matt Thomas of 3am Software Foundry.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#define SUNXI_HDMI_VERSION_ID_REG	0x0000
#define SUNXI_HDMI_CTRL_REG		0x0004
#define SUNXI_HDMI_INT_STATUS_REG	0x0008
#define SUNXI_HDMI_HPD_REG		0x000c
#define SUNXI_HDMI_VID_CTRL_REG		0x0010
#define SUNXI_HDMI_VID_TIMING_0_REG	0x0014
#define SUNXI_HDMI_VID_TIMING_1_REG	0x0018
#define SUNXI_HDMI_VID_TIMING_2_REG	0x001c
#define SUNXI_HDMI_VID_TIMING_3_REG	0x0020
#define SUNXI_HDMI_VID_TIMING_4_REG	0x0024
#define SUNXI_HDMI_AUD_CTRL_REG		0x0040
#define SUNXI_HDMI_ADMA_CTRL_REG	0x0044
#define SUNXI_HDMI_AUD_FMT_REG		0x0048
#define SUNXI_HDMI_AUD_PCM_CTRL_REG	0x004c
#define SUNXI_HDMI_AUD_CTS_REG		0x0050
#define SUNXI_HDMI_AUD_N_REG		0x0054
#define SUNXI_HDMI_AUD_CH_STATUS0_REG	0x0058
#define SUNXI_HDMI_AUD_CH_STATUS1_REG	0x005c
#define SUNXI_HDMI_AVI_INFO_PKT_REG	0x0080
#define SUNXI_HDMI_AUD_INFO_PKT_REG	0x00a0
#define SUNXI_HDMI_ACP_PKT_REG		0x00c0
#define SUNXI_HDMI_GP_PKT0_REG		0x00e0
#define SUNXI_HDMI_GP_PKT1_REG		0x00e0
#define SUNXI_HDMI_PAD_CTRL0_REG	0x0200
#define SUNXI_HDMI_PAD_CTRL1_REG	0x0204
#define SUNXI_HDMI_PLL_CTRL_REG		0x0208
#define SUNXI_HDMI_PLL_DBG0_REG		0x020c
#define SUNXI_HDMI_PLL_DBG1_REG		0x0210
#define SUNXI_HDMI_HPD_CEC_REG		0x0214
#define SUNXI_HDMI_SPD_PKT_REG		0x0240
#define SUNXI_HDMI_PKT_CTRL0_REG	0x02f0
#define SUNXI_HDMI_PKT_CTRL1_REG	0x02f4
#define SUNXI_HDMI_DBG4_REG		0x0310
#define SUNXI_HDMI_AUX_TX_FIFO_REG	0x0400
#define SUNXI_HDMI_DDC_CTRL_REG		0x0500
#define SUNXI_HDMI_DDC_SLAVE_ADDR_REG	0x0504
#define SUNXI_HDMI_DDC_INT_MASK_REG	0x0508
#define SUNXI_HDMI_DDC_INT_STATUS_REG	0x050c
#define SUNXI_HDMI_DDC_FIFO_CTRL_REG	0x0510
#define SUNXI_HDMI_DDC_FIFO_STATUS_REG	0x0514
#define SUNXI_HDMI_DDC_FIFO_ACCESS_REG	0x0518
#define SUNXI_HDMI_DDC_BYTE_COUNTER_REG	0x051c
#define SUNXI_HDMI_DDC_COMMAND_REG	0x0520
#define SUNXI_HDMI_DDC_EX_REG		0x0524
#define SUNXI_HDMI_DDC_CLOCK_REG	0x0528
#define SUNXI_HDMI_DDC_DBG_REG		0x0540

#define SUNXI_HDMI_VERSION_ID_H		__BITS(31,16)
#define SUNXI_HDMI_VERSION_ID_L		__BITS(15,0)

#define SUNXI_HDMI_CTRL_MODULE_EN	__BIT(31)
#define SUNXI_HDMI_CTRL_HDCP_EN		__BIT(30)
#define SUNXI_HDMI_CTRL_CLR_AVMUTE	__BIT(1)
#define SUNXI_HDMI_CTRL_SET_AVMUTE	__BIT(0)

#define SUNXI_HDMI_HPD_HOTPLUG_DET	__BIT(0)

#define SUNXI_HDMI_VID_CTRL_VIDEO_EN	__BIT(31)
#define SUNXI_HDMI_VID_CTRL_HDMI_MODE	__BIT(30)
#define SUNXI_HDMI_VID_CTRL_HDMI_MODE_DVI	0
#define SUNXI_HDMI_VID_CTRL_HDMI_MODE_HDMI	1
#define SUNXI_HDMI_VID_CTRL_SRC_SEL	__BIT(5)
#define SUNXI_HDMI_VID_CTRL_SRC_SEL_RGB		0
#define SUNXI_HDMI_VID_CTRL_SRC_SEL_CBGEN	1
#define SUNXI_HDMI_VID_CTRL_OUTPUT_FMT	__BIT(4)
#define SUNXI_HDMI_VID_CTRL_OUTPUT_FMT_PROGRESS	0
#define SUNXI_HDMI_VID_CTRL_OUTPUT_FMT_INTERLACE	1
#define SUNXI_HDMI_VID_CTRL_COLOR_MODE	__BITS(3,2)
#define SUNXI_HDMI_VID_CTRL_COLOR_MODE_24	0
#define SUNXI_HDMI_VID_CTRL_COLOR_MODE_30	1
#define SUNXI_HDMI_VID_CTRL_COLOR_MODE_36	2
#define SUNXI_HDMI_VID_CTRL_COLOR_MODE_48	3
#define SUNXI_HDMI_VID_CTRL_REPEATER_SEL	__BITS(1,0)
#define SUNXI_HDMI_VID_CTRL_REPEATER_SEL_NORMAL	0
#define SUNXI_HDMI_VID_CTRL_REPEATER_SEL_2X	1
#define SUNXI_HDMI_VID_CTRL_REPEATER_SEL_4X	2

#define SUNXI_HDMI_VID_TIMING_0_ACT_V	__BITS(27,16)
#define SUNXI_HDMI_VID_TIMING_0_ACT_H	__BITS(11,0)

#define SUNXI_HDMI_VID_TIMING_1_VBP	__BITS(27,16)
#define SUNXI_HDMI_VID_TIMING_1_HBP	__BITS(11,0)

#define SUNXI_HDMI_VID_TIMING_2_VFP	__BITS(27,16)
#define SUNXI_HDMI_VID_TIMING_2_HFP	__BITS(11,0)

#define SUNXI_HDMI_VID_TIMING_3_VSPW	__BITS(27,16)
#define SUNXI_HDMI_VID_TIMING_3_HSPW	__BITS(11,0)

#define SUNXI_HDMI_VID_TIMING_4_TX_CLOCK	__BITS(25,16)
#define SUNXI_HDMI_VID_TIMING_4_TX_CLOCK_NORMAL	0x3e0
#define SUNXI_HDMI_VID_TIMING_4_VSYNC_ACTIVE_SEL __BIT(1)
#define SUNXI_HDMI_VID_TIMING_4_HSYNC_ACTIVE_SEL __BIT(0)

#define SUNXI_HDMI_PAD_CTRL0_BIAS	__BIT(31)
#define SUNXI_HDMI_PAD_CTRL0_LDOCEN	__BIT(30)
#define SUNXI_HDMI_PAD_CTRL0_LD0DEN	__BIT(29)
#define SUNXI_HDMI_PAD_CTRL0_PWENC	__BIT(28)
#define SUNXI_HDMI_PAD_CTRL0_PWEND	__BIT(27)
#define SUNXI_HDMI_PAD_CTRL0_PWENG	__BIT(26)
#define SUNXI_HDMI_PAD_CTRL0_CKEN	__BIT(25)
#define SUNXI_HDMI_PAD_CTRL0_SEN	__BIT(24)
#define SUNXI_HDMI_PAD_CTRL0_TXEN	__BIT(23)
#define SUNXI_HDMI_PAD_CTRL0_AUTOSYNC_DIS __BIT(22)
#define SUNXI_HDMI_PAD_CTRL0_LSB_MSB	__BIT(21)

#define SUNXI_HDMI_PAD_CTRL1_AMP_OPT	__BIT(23)
#define SUNXI_HDMI_PAD_CTRL1_AMPCK_OPT	__BIT(22)
#define SUNXI_HDMI_PAD_CTRL1_DMP_OPT	__BIT(21)
#define SUNXI_HDMI_PAD_CTRL1_EMP_OPT	__BIT(20)
#define SUNXI_HDMI_PAD_CTRL1_EMPCK_OPT	__BIT(19)
#define SUNXI_HDMI_PAD_CTRL1_PWSCK	__BIT(18)
#define SUNXI_HDMI_PAD_CTRL1_PWSDT	__BIT(17)
#define SUNXI_HDMI_PAD_CTRL1_REG_CSMPS	__BIT(16)
#define SUNXI_HDMI_PAD_CTRL1_REG_DEN	__BIT(15)
#define SUNXI_HDMI_PAD_CTRL1_REG_DENCK	__BIT(14)
#define SUNXI_HDMI_PAD_CTRL1_REG_PLRCK	__BIT(13)
#define SUNXI_HDMI_PAD_CTRL1_REG_EMP	__BITS(12,10)
#define SUNXI_HDMI_PAD_CTRL1_REG_CD	__BITS(9,8)
#define SUNXI_HDMI_PAD_CTRL1_REG_CKSS	__BITS(7,6)
#define SUNXI_HDMI_PAD_CTRL1_REG_AMP	__BITS(5,3)
#define SUNXI_HDMI_PAD_CTRL1_REG_PLR	__BITS(2,0)

#define SUNXI_HDMI_PLL_CTRL_PLL_EN	__BIT(31)
#define SUNXI_HDMI_PLL_CTRL_BWS		__BIT(30)
#define SUNXI_HDMI_PLL_CTRL_HV_IS_33	__BIT(29)
#define SUNXI_HDMI_PLL_CTRL_LDO1_EN	__BIT(28)
#define SUNXI_HDMI_PLL_CTRL_LDO2_EN	__BIT(27)
#define SUNXI_HDMI_PLL_CTRL_S6P25_7P5	__BIT(26)
#define SUNXI_HDMI_PLL_CTRL_SDIV2	__BIT(25)
#define SUNXI_HDMI_PLL_CTRL_SINT_FRAC	__BIT(24)
#define SUNXI_HDMI_PLL_CTRL_VCO_GAIN_EN	__BIT(23)
#define SUNXI_HDMI_PLL_CTRL_VCO_GAIN	__BITS(22,20)
#define SUNXI_HDMI_PLL_CTRL_S		__BITS(19,17)
#define SUNXI_HDMI_PLL_CTRL_CP_S	__BITS(16,12)
#define SUNXI_HDMI_PLL_CTRL_CS		__BITS(11,8)
#define SUNXI_HDMI_PLL_CTRL_PREDIV	__BITS(7,4)
#define SUNXI_HDMI_PLL_CTRL_VCO_S	__BITS(3,0)

#define SUNXI_HDMI_AUD_CTRL_EN		__BIT(31)
#define SUNXI_HDMI_AUD_CTRL_RST		__BIT(30)

#define SUNXI_HDMI_ADMA_CTRL_SRC_DMA_MODE __BIT(31)
#define SUNXI_HDMI_ADMA_CTRL_DMA_REQ_CTRL __BITS(25,24)
#define SUNXI_HDMI_ADMA_CTRL_SRC_DMA_SAMPLE_RATE __BIT(19)
#define SUNXI_HDMI_ADMA_CTRL_SRC_SAMPLE_LAYOUT __BIT(18)
#define SUNXI_HDMI_ADMA_CTRL_SRC_WORD_LEN __BITS(17,16)
#define SUNXI_HDMI_ADMA_CTRL_FIFO_CLEAR	__BIT(15)
#define SUNXI_HDMI_ADMA_CTRL_DATA_SEL	__BIT(0)

#define SUNXI_HDMI_AUD_FMT_SRC_SEL	__BIT(31)
#define SUNXI_HDMI_AUD_FMT_SEL		__BITS(26,24)
#define SUNXI_HDMI_AUD_FMT_DSD_FMT	__BIT(4)
#define SUNXI_HDMI_AUD_FMT_LAYOUT	__BIT(3)
#define SUNXI_HDMI_AUD_FMT_SRC_CH_CFG	__BITS(2,0)

#define SUNXI_HDMI_AUD_CH_STATUS0_CHNL_BIT1	__BITS(31,30)
#define SUNXI_HDMI_AUD_CH_STATUS0_CLK_ACCUR	__BITS(29,28)
#define SUNXI_HDMI_AUD_CH_STATUS0_FS_FREQ	__BITS(27,24)
#define SUNXI_HDMI_AUD_CH_STATUS0_FS_FREQ_44_1	0
#define SUNXI_HDMI_AUD_CH_STATUS0_FS_FREQ_48	2
#define SUNXI_HDMI_AUD_CH_STATUS0_FS_FREQ_32	3
#define SUNXI_HDMI_AUD_CH_STATUS0_FS_FREQ_88_2	8
#define SUNXI_HDMI_AUD_CH_STATUS0_FS_FREQ_96	10
#define SUNXI_HDMI_AUD_CH_STATUS0_FS_FREQ_176_4	12
#define SUNXI_HDMI_AUD_CH_STATUS0_FS_FREQ_192	14
#define SUNXI_HDMI_AUD_CH_STATUS0_CH_NUM	__BITS(23,20)
#define SUNXI_HDMI_AUD_CH_STATUS0_SOURCE_NUM	__BITS(19,16)
#define SUNXI_HDMI_AUD_CH_STATUS0_CATEGORY_CODE	__BITS(15,8)
#define SUNXI_HDMI_AUD_CH_STATUS0_MODE		__BITS(7,6)
#define SUNXI_HDMI_AUD_CH_STATUS0_EMPHASIS	__BITS(5,3)
#define SUNXI_HDMI_AUD_CH_STATUS0_CP		__BIT(2)
#define SUNXI_HDMI_AUD_CH_STATUS0_DATA_TYPE	__BIT(1)
#define SUNXI_HDMI_AUD_CH_STATUS0_APP_TYPE	__BIT(0)

#define SUNXI_HDMI_AUD_CH_STATUS1_CGMS_A	__BITS(9,8)
#define SUNXI_HDMI_AUD_CH_STATUS1_ORIGINAL_FS	__BITS(7,4)
#define SUNXI_HDMI_AUD_CH_STATUS1_WORD_LEN	__BITS(3,1)
#define SUNXI_HDMI_AUD_CH_STATUS1_WORD_LEN_MAX	__BIT(0)

#define SUNXI_HDMI_DDC_CTRL_EN		__BIT(31)
#define SUNXI_HDMI_DDC_CTRL_ACCESS_CMD_START __BIT(30)
#define SUNXI_HDMI_DDC_CTRL_FIFO_DIR	__BIT(8)
#define SUNXI_HDMI_DDC_CTRL_FIFO_DIR_READ	0
#define SUNXI_HDMI_DDC_CTRL_FIFO_DIR_WRITE	1
#define SUNXI_HDMI_DDC_CTRL_SW_RST	__BIT(0)

#define SUNXI_HDMI_DDC_SLAVE_ADDR_0	__BITS(31,24)
#define SUNXI_HDMI_DDC_SLAVE_ADDR_1	__BITS(23,16)
#define SUNXI_HDMI_DDC_SLAVE_ADDR_2	__BITS(15,8)
#define SUNXI_HDMI_DDC_SLAVE_ADDR_3	__BITS(6,0)

#define SUNXI_HDMI_DDC_INT_STATUS_CLEAR	__BIT(8)
#define SUNXI_HDMI_DDC_INT_STATUS_ILLEGAL_FIFO_OP __BIT(7)
#define SUNXI_HDMI_DDC_INT_STATUS_RX_UNDERFLOW __BIT(6)
#define SUNXI_HDMI_DDC_INT_STATUS_TX_OVERFLOW __BIT(5)
#define SUNXI_HDMI_DDC_INT_STATUS_FIFO_REQ __BIT(4)
#define SUNXI_HDMI_DDC_INT_STATUS_ARB_ERR __BIT(3)
#define SUNXI_HDMI_DDC_INT_STATUS_ACK_ERR __BIT(2)
#define SUNXI_HDMI_DDC_INT_STATUS_BUS_ERR __BIT(1)
#define SUNXI_HDMI_DDC_INT_STATUS_TRANSFER_COMPLETE __BIT(0)

#define SUNXI_HDMI_DDC_FIFO_CTRL_ADDR_CLEAR __BIT(31)
#define SUNXI_HDMI_DDC_FIFO_CTRL_REQUEST_EN __BIT(8)
#define SUNXI_HDMI_DDC_FIFO_CTRL_RX_TRIGGER_THRESH __BITS(7,4)
#define SUNXI_HDMI_DDC_FIFO_CTRL_TX_TRIGGER_THRESH __BITS(3,0)

#define SUNXI_HDMI_DDC_FIFO_STATUS_REQ_READY	__BIT(7)
#define SUNXI_HDMI_DDC_FIFO_STATUS_FULL		__BIT(6)
#define SUNXI_HDMI_DDC_FIFO_STATUS_EMPTY	__BIT(5)
#define SUNXI_HDMI_DDC_FIFO_STATUS_LEVEL	__BITS(4,0)

#define SUNXI_HDMI_DDC_COMMAND_ACCESS_CMD	__BITS(2,0)
#define SUNXI_HDMI_DDC_COMMAND_ACCESS_CMD_ABORT	0
#define SUNXI_HDMI_DDC_COMMAND_ACCESS_CMD_SOREAD	1
#define SUNXI_HDMI_DDC_COMMAND_ACCESS_CMD_EOWRITE 2
#define SUNXI_HDMI_DDC_COMMAND_ACCESS_CMD_IOWRITE 3
#define SUNXI_HDMI_DDC_COMMAND_ACCESS_CMD_EOREAD	4
#define SUNXI_HDMI_DDC_COMMAND_ACCESS_CMD_IOREAD	5
#define SUNXI_HDMI_DDC_COMMAND_ACCESS_CMD_EOEDDCREAD 6
#define SUNXI_HDMI_DDC_COMMAND_ACCESS_CMD_IOEDDCREAD 7

#define SUNXI_HDMI_DDC_CLOCK_M		__BITS(6,3)
#define SUNXI_HDMI_DDC_CLOCK_N		__BITS(2,0)

#define SUNXI_A31_HDMI_DDC_CTRL_REG		0x0500
#define SUNXI_A31_HDMI_DDC_EXCTRL_REG		0x0504
#define SUNXI_A31_HDMI_DDC_COMMAND_REG		0x0508
#define SUNXI_A31_HDMI_DDC_SLAVE_ADDR_REG	0x050c
#define SUNXI_A31_HDMI_DDC_INT_MASK_REG		0x0510
#define SUNXI_A31_HDMI_DDC_INT_STATUS_REG	0x0514
#define SUNXI_A31_HDMI_DDC_FIFO_CTRL_REG	0x0518
#define SUNXI_A31_HDMI_DDC_FIFO_STATUS_REG	0x051c
#define SUNXI_A31_HDMI_DDC_CLOCK_REG		0x0520
#define SUNXI_A31_HDMI_DDC_TIMEOUT_REG		0x0524
#define SUNXI_A31_HDMI_DDC_FIFO_ACCESS_REG	0x0580

#define SUNXI_A31_HDMI_DDC_CTRL_SW_RST		__BIT(31)
#define SUNXI_A31_HDMI_DDC_CTRL_ACCESS_CMD_START __BIT(27)
#define SUNXI_A31_HDMI_DDC_CTRL_SDA_PAD_PULLDOWN __BIT(7)
#define SUNXI_A31_HDMI_DDC_CTRL_SDA_PAD_EN	__BIT(6)
#define SUNXI_A31_HDMI_DDC_CTRL_SCL_PAD_PULLDOWN __BIT(5)
#define SUNXI_A31_HDMI_DDC_CTRL_SCL_PAD_EN	__BIT(4)
#define SUNXI_A31_HDMI_DDC_CTRL_EN		__BIT(0)

#define SUNXI_A31_HDMI_DDC_EXCTRL_BUS_BUSY	__BIT(10)
#define SUNXI_A31_HDMI_DDC_EXCTRL_SCL_STATUS	__BIT(9)
#define SUNXI_A31_HDMI_DDC_EXCTRL_SDA_STATUS	__BIT(8)
#define SUNXI_A31_HDMI_DDC_EXCTRL_SEGMENT_SEL	__BIT(7)
#define SUNXI_A31_HDMI_DDC_EXCTRL_SEGMENT0_DET	__BIT(6)
#define SUNXI_A31_HDMI_DDC_EXCTRL_INIT_SEQ_MODE	__BIT(5)
#define SUNXI_A31_HDMI_DDC_EXCTRL_INIT_SEQ_EN	__BIT(4)
#define SUNXI_A31_HDMI_DDC_EXCTRL_SW_SCL	__BIT(3)
#define SUNXI_A31_HDMI_DDC_EXCTRL_SW_SCL_EN	__BIT(2)
#define SUNXI_A31_HDMI_DDC_EXCTRL_SW_SDA	__BIT(1)
#define SUNXI_A31_HDMI_DDC_EXCTRL_SW_SDA_EN	__BIT(0)

#define SUNXI_A31_HDMI_DDC_COMMAND_DTC		__BITS(25,16)
#define SUNXI_A31_HDMI_DDC_COMMAND_CMD		__BITS(2,0)

#define SUNXI_A31_HDMI_DDC_FIFO_CTRL_RST	__BIT(15)

#define SUNXI_A31_HDMI_DDC_SLAVE_ADDR_SEG_PTR	__BITS(31,24)
#define SUNXI_A31_HDMI_DDC_SLAVE_ADDR_DDC_CMD	__BITS(23,16)
#define SUNXI_A31_HDMI_DDC_SLAVE_ADDR_OFF_ADR	__BITS(15,8)
#define SUNXI_A31_HDMI_DDC_SLAVE_ADDR_DEV_ADR	__BITS(7,1)

