/*
Original work Copyright (c) 2018 Shannon Miwa
Modified work Copyright (c) 2019 dtinth

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

/*
 * a rendering of the Comic Mono font found here:
 * https://github.com/dtinth/comic-mono-font/
 */
static u_char Comic_Mono_12x25_data[];

static struct wsdisplay_font Comic_Mono_12x25 = {
	"Comic Mono",			/* typeface name */
	32,				/* firstchar */
	127 - 32,			/* numchar */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	12,				/* width */
	25,				/* height */
	12,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	Comic_Mono_12x25_data		/* data */
};

static u_char Comic_Mono_12x25_data[] = {
	/* 32 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 33 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0xc9, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, /*      Oa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x15, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x10, 0xe1, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, /*      Xa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x84, 0xf4, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXo      */
0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXX      */
0x00, 0x00, 0x00, 0x00, 0x84, 0xe5, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oX+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 34 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0xd9, 0xc2, 0x00, 0xc6, 0xd1, 0x00, 0x00, 0x00, 0x00, /*    OO OO     */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, 0x00, /*    XX XX     */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, 0x00, /*    XX XX     */
0x00, 0x00, 0x00, 0xff, 0xef, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, 0x00, /*    XX XX     */
0x00, 0x00, 0x00, 0xff, 0xed, 0x00, 0xf0, 0xfd, 0x00, 0x00, 0x00, 0x00, /*    XX XX     */
0x00, 0x00, 0x00, 0xff, 0xe6, 0x00, 0xf0, 0xf6, 0x00, 0x00, 0x00, 0x00, /*    XX XX     */
0x00, 0x00, 0x00, 0xcf, 0xa0, 0x00, 0xbf, 0xb0, 0x00, 0x00, 0x00, 0x00, /*    Oa aa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 35 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x14, 0xae, 0x41, 0x00, 0x01, 0x7a, 0x3e, 0x00, /*      a-  +.  */
0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0x92, 0x00, 0x37, 0xff, 0xba, 0x00, /*     +Xo .Xa  */
0x00, 0x00, 0x00, 0x00, 0x95, 0xff, 0x63, 0x00, 0x6a, 0xff, 0x8b, 0x00, /*     oX+ +Xo  */
0x00, 0x00, 0x00, 0x00, 0xc7, 0xff, 0x31, 0x00, 0x9b, 0xff, 0x5b, 0x00, /*     OX. oX-  */
0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x00, /*   OXXXXXXXO  */
0x00, 0x00, 0x5e, 0xaa, 0xff, 0xe2, 0x90, 0x92, 0xff, 0xf4, 0x70, 0x00, /*   -aXXooXX+  */
0x00, 0x00, 0x00, 0x64, 0xff, 0x99, 0x00, 0x27, 0xff, 0xc8, 0x00, 0x00, /*    +Xo .XO   */
0x00, 0x00, 0x00, 0x9a, 0xff, 0x67, 0x00, 0x54, 0xff, 0x9e, 0x00, 0x00, /*    oX+ -Xo   */
0x00, 0x00, 0x00, 0xd1, 0xff, 0x35, 0x00, 0x81, 0xff, 0x74, 0x00, 0x00, /*    OX. oX+   */
0x00, 0xcb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdd, 0x00, /*  OXXXXXXXXO  */
0x00, 0x68, 0xaa, 0xff, 0xe4, 0x90, 0x90, 0xf7, 0xff, 0x95, 0x67, 0x00, /*  +aXXooXXo+  */
0x00, 0x00, 0x65, 0xff, 0x99, 0x00, 0x10, 0xff, 0xeb, 0x00, 0x00, 0x00, /*   +Xo  XX    */
0x00, 0x00, 0xa0, 0xff, 0x64, 0x00, 0x46, 0xff, 0xbc, 0x00, 0x00, 0x00, /*   aX+ -Xa    */
0x00, 0x00, 0xb4, 0xf9, 0x23, 0x00, 0x5f, 0xff, 0x75, 0x00, 0x00, 0x00, /*   aX. -X+    */
0x00, 0x00, 0x14, 0x21, 0x00, 0x00, 0x04, 0x3b, 0x01, 0x00, 0x00, 0x00, /*    .   .     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 36 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x4b, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     --       */
0x00, 0x00, 0x00, 0x00, 0xe6, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x2b, 0xa2, 0xfd, 0xff, 0xf0, 0xba, 0x4d, 0x00, 0x00, 0x00, /*   .aXXXa-    */
0x00, 0x2f, 0xf0, 0xf6, 0xfc, 0xff, 0xa1, 0xea, 0xda, 0x00, 0x00, 0x00, /*  .XXXXaXO    */
0x00, 0xb1, 0xff, 0x47, 0xf0, 0xff, 0x00, 0x04, 0x0f, 0x00, 0x00, 0x00, /*  aX-XX       */
0x00, 0xed, 0xf8, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX XX       */
0x00, 0xec, 0xff, 0x35, 0xf0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX.XX       */
0x00, 0x87, 0xff, 0xf5, 0xfb, 0xff, 0x63, 0x20, 0x00, 0x00, 0x00, 0x00, /*  oXXXX+.     */
0x00, 0x02, 0x75, 0xd0, 0xfe, 0xff, 0xff, 0xfe, 0xa0, 0x04, 0x00, 0x00, /*   +OXXXXa    */
0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x7f, 0xf4, 0xff, 0x82, 0x00, 0x00, /*     XX+XXo   */
0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x4a, 0xff, 0xe3, 0x00, 0x00, /*     XX -XX   */
0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0xf9, 0xf8, 0x00, 0x00, /*     XX  XX   */
0x1e, 0x3b, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x2f, 0xff, 0xcf, 0x00, 0x00, /*  .  XX .XO   */
0xb1, 0xfb, 0x4c, 0x00, 0xf0, 0xff, 0x2d, 0xdb, 0xff, 0x4e, 0x00, 0x00, /* aX- XX.OX-   */
0x4c, 0xfd, 0xf8, 0xa8, 0xf9, 0xff, 0xfd, 0xfd, 0x79, 0x00, 0x00, 0x00, /* -XXaXXXX+    */
0x00, 0x42, 0xbe, 0xf1, 0xff, 0xff, 0x9b, 0x33, 0x00, 0x00, 0x00, 0x00, /*  -aXXXo.     */
0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xd2, 0xc7, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OO       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 37 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x19, 0xb7, 0xf3, 0xc7, 0x28, 0x00, 0x00, 0x10, 0x73, 0x12, 0x00, /*   aXO.   +   */
0x00, 0xad, 0xff, 0xba, 0xd3, 0xbc, 0x00, 0x00, 0x8f, 0xff, 0x43, 0x00, /*  aXaOa  oX-  */
0x00, 0xf0, 0xfb, 0x07, 0x3b, 0xeb, 0x00, 0x19, 0xf6, 0xc2, 0x00, 0x00, /*  XX .X  XO   */
0x00, 0xeb, 0xff, 0x2b, 0x6e, 0xe9, 0x00, 0x98, 0xfe, 0x33, 0x00, 0x00, /*  XX.+X oX.   */
0x00, 0x83, 0xff, 0xff, 0xff, 0x94, 0x28, 0xfb, 0xa2, 0x00, 0x00, 0x00, /*  oXXXo.Xa    */
0x00, 0x01, 0x5a, 0x86, 0x5a, 0x02, 0xb2, 0xf6, 0x1d, 0x00, 0x00, 0x00, /*   -o- aX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, /*      -Xo     */
0x00, 0x00, 0x00, 0x00, 0x01, 0xce, 0xeb, 0x0e, 0x00, 0x00, 0x00, 0x00, /*      OX      */
0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x6c, 0x47, 0x83, 0x5c, 0x02, 0x00, /*     -X+-o-   */
0x00, 0x00, 0x00, 0x0a, 0xe4, 0xda, 0x72, 0xff, 0xff, 0xff, 0x97, 0x00, /*     XO+XXXo  */
0x00, 0x00, 0x00, 0x7d, 0xff, 0x53, 0xdf, 0xff, 0x29, 0xb0, 0xe8, 0x00, /*    +X-OX.aX  */
0x00, 0x00, 0x17, 0xf3, 0xc8, 0x00, 0xf8, 0xf8, 0x01, 0x93, 0xf7, 0x00, /*    XO XX oX  */
0x00, 0x00, 0x96, 0xff, 0x3f, 0x00, 0xc0, 0xff, 0xac, 0xed, 0xcd, 0x00, /*   oX. OXaXO  */
0x00, 0x1f, 0xfb, 0xb7, 0x00, 0x00, 0x26, 0xcc, 0xf6, 0xcb, 0x32, 0x00, /*   Xa  .OXO.  */
0x00, 0x36, 0xe8, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .X.         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 38 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x1a, 0xac, 0xed, 0xea, 0x95, 0x0a, 0x00, 0x00, 0x00, /*     aXXo     */
0x00, 0x00, 0x00, 0xbc, 0xff, 0xb6, 0xcf, 0xff, 0x98, 0x00, 0x00, 0x00, /*    aXaOXo    */
0x00, 0x00, 0x00, 0xf9, 0xf9, 0x04, 0x18, 0xff, 0xe0, 0x00, 0x00, 0x00, /*    XX  XX    */
0x00, 0x00, 0x00, 0xde, 0xfe, 0x0f, 0x15, 0xff, 0xd0, 0x00, 0x00, 0x00, /*    OX  XO    */
0x00, 0x00, 0x00, 0x6b, 0xff, 0x82, 0xad, 0xff, 0x6e, 0x00, 0x00, 0x00, /*    +XoaX+    */
0x00, 0x00, 0x00, 0x09, 0xe2, 0xff, 0xfb, 0x80, 0x00, 0x00, 0x00, 0x00, /*     XXXo     */
0x00, 0x00, 0x42, 0xe3, 0xff, 0xff, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -XXXo      */
0x00, 0x30, 0xf6, 0xf7, 0x62, 0x68, 0xf8, 0x30, 0x00, 0x56, 0xae, 0x02, /*  .XX++X. -a  */
0x00, 0xac, 0xff, 0x69, 0x00, 0x00, 0xb0, 0xd9, 0x1e, 0xf1, 0xf3, 0x06, /*  aX+  aO XX  */
0x00, 0xe6, 0xff, 0x12, 0x00, 0x00, 0x15, 0xed, 0xe8, 0xff, 0x61, 0x00, /*  XX    XXX+  */
0x00, 0xf6, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x79, 0xff, 0xb8, 0x00, 0x00, /*  XX    +Xa   */
0x00, 0xc2, 0xff, 0x73, 0x00, 0x00, 0x08, 0xbd, 0xff, 0xf3, 0x19, 0x00, /*  OX+   aXX   */
0x00, 0x3c, 0xfa, 0xff, 0xb8, 0x99, 0xde, 0xda, 0x97, 0xff, 0x99, 0x00, /*  .XXaoOOoXo  */
0x00, 0x00, 0x39, 0xbc, 0xf3, 0xf1, 0xa6, 0x17, 0x15, 0xe4, 0xbf, 0x00, /*   .aXXa  Xa  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 39 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0xde, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OO       */
0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xff, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xd1, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     Oa       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 40 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xdb, 0xd8, 0x00, 0x00, 0x00, 0x00, /*      -OO     */
0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb6, 0x6a, 0x00, 0x00, 0x00, 0x00, /*     +Xa+     */
0x00, 0x00, 0x00, 0x43, 0xff, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -X+       */
0x00, 0x00, 0x00, 0xc6, 0xcd, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OO        */
0x00, 0x00, 0x17, 0xfe, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    X+        */
0x00, 0x00, 0x52, 0xff, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -X.        */
0x00, 0x00, 0x77, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +X         */
0x00, 0x00, 0x93, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oX         */
0x00, 0x00, 0xa2, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aX         */
0x00, 0x00, 0xa8, 0xff, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aX         */
0x00, 0x00, 0x9e, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oX         */
0x00, 0x00, 0x81, 0xff, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oX-        */
0x00, 0x00, 0x57, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -X+        */
0x00, 0x00, 0x17, 0xfe, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XO        */
0x00, 0x00, 0x00, 0xc2, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OX.       */
0x00, 0x00, 0x00, 0x44, 0xff, 0xcc, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XO       */
0x00, 0x00, 0x00, 0x00, 0x93, 0xff, 0xd5, 0x6f, 0x00, 0x00, 0x00, 0x00, /*     oXO+     */
0x00, 0x00, 0x00, 0x00, 0x02, 0x71, 0xdc, 0xd2, 0x00, 0x00, 0x00, 0x00, /*      +OO     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 41 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0xdf, 0xdb, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OO-        */
0x00, 0x00, 0x66, 0xb6, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +aX+       */
0x00, 0x00, 0x00, 0x00, 0x7d, 0xfe, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +X-      */
0x00, 0x00, 0x00, 0x00, 0x02, 0xd0, 0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OO      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0x16, 0x00, 0x00, 0x00, 0x00, /*      +X      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, /*      .X-     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x73, 0x00, 0x00, 0x00, 0x00, /*       X+     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x8f, 0x00, 0x00, 0x00, 0x00, /*       Xo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x9f, 0x00, 0x00, 0x00, 0x00, /*       Xo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, /*       Xa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xff, 0xa1, 0x00, 0x00, 0x00, 0x00, /*       Xa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, /*      -Xo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0x57, 0x00, 0x00, 0x00, 0x00, /*      +X-     */
0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xfd, 0x16, 0x00, 0x00, 0x00, 0x00, /*      OX      */
0x00, 0x00, 0x00, 0x00, 0x35, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .Xa      */
0x00, 0x00, 0x00, 0x0a, 0xcd, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OX-      */
0x00, 0x00, 0x6e, 0xd4, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +OXo       */
0x00, 0x00, 0xd2, 0xdd, 0x72, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OO+        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 42 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x2b, 0x59, 0x00, 0x00, 0x22, 0x5d, 0x00, 0x00, 0x00, 0x00, /*   .-  .-     */
0x00, 0x00, 0x94, 0xff, 0x42, 0x00, 0xc8, 0xfd, 0x08, 0x00, 0x00, 0x00, /*   oX- OX     */
0x00, 0x00, 0x33, 0xfd, 0xb9, 0x41, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, /*   .Xa-Xa     */
0x00, 0x00, 0x00, 0x98, 0xff, 0xdb, 0xf6, 0x1c, 0x00, 0x00, 0x00, 0x00, /*    oXOX      */
0x36, 0x9e, 0x95, 0xa6, 0xff, 0xff, 0xdc, 0x98, 0xb2, 0x9b, 0x00, 0x00, /* .ooaXXOoao   */
0x5b, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, /* -XXXXXXXXX   */
0x00, 0x00, 0x00, 0x97, 0xff, 0xf1, 0xdc, 0x0a, 0x0e, 0x0f, 0x00, 0x00, /*    oXXO      */
0x00, 0x00, 0x36, 0xfd, 0xe0, 0x4f, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, /*   .XX-X+     */
0x00, 0x00, 0x9a, 0xff, 0x6e, 0x00, 0xdb, 0xef, 0x00, 0x00, 0x00, 0x00, /*   oX+ OX     */
0x00, 0x00, 0x23, 0x74, 0x08, 0x00, 0x30, 0x62, 0x00, 0x00, 0x00, 0x00, /*   .+  .+     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 43 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x50, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     --       */
0x00, 0x00, 0x00, 0x00, 0xfa, 0xed, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x65, 0x90, 0x90, 0xff, 0xf9, 0x90, 0x90, 0x5c, 0x00, 0x00, 0x00, /*  +ooXXoo-    */
0x00, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc5, 0x00, 0x00, 0x00, /*  OXXXXXXO    */
0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x01, 0x07, 0x04, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xd6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OO       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 44 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x12, 0xea, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, /*      Xo      */
0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -Xo      */
0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aX-      */
0x00, 0x00, 0x00, 0x10, 0xf8, 0xf6, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x69, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +Xa       */
0x00, 0x00, 0x03, 0xd8, 0xff, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OX-       */
0x00, 0x00, 0x19, 0xf8, 0xb0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    Xa        */
0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 45 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x67, 0x90, 0x90, 0x90, 0x90, 0x72, 0x00, 0x00, 0x00, 0x00, /*   +oooo+     */
0x00, 0x00, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, /*   OXXXXO     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 46 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x84, 0xf4, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXo      */
0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXX      */
0x00, 0x00, 0x00, 0x00, 0x84, 0xe5, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oX+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 47 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xcd, 0xa7, 0x00, 0x00, /*         Oa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xae, 0x00, 0x00, /*        +Xa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xeb, 0xfc, 0x2c, 0x00, 0x00, /*        XX.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xff, 0x96, 0x00, 0x00, 0x00, /*       +Xo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf1, 0xed, 0x13, 0x00, 0x00, 0x00, /*       XX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, /*      oX+     */
0x00, 0x00, 0x00, 0x00, 0x24, 0xfa, 0xd0, 0x03, 0x00, 0x00, 0x00, 0x00, /*     .XO      */
0x00, 0x00, 0x00, 0x00, 0xad, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aX.      */
0x00, 0x00, 0x00, 0x3e, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .Xa       */
0x00, 0x00, 0x02, 0xce, 0xf5, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OX        */
0x00, 0x00, 0x67, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +X+        */
0x00, 0x11, 0xeb, 0xeb, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x95, 0xff, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  oX+         */
0x2f, 0xfc, 0xee, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .XX          */
0x91, 0xff, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* oX+          */
0x49, 0x8e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* -o           */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 48 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x09, 0x80, 0xd6, 0xf6, 0xec, 0x9e, 0x15, 0x00, 0x00, 0x00, /*    oOXXo     */
0x00, 0x05, 0xc9, 0xff, 0xd3, 0x99, 0xd0, 0xff, 0xd8, 0x0b, 0x00, 0x00, /*   OXOoOXO    */
0x00, 0x68, 0xff, 0xc0, 0x03, 0x00, 0x06, 0xd3, 0xff, 0x73, 0x00, 0x00, /*  +XO   OX+   */
0x00, 0xb6, 0xff, 0x4f, 0x00, 0x00, 0x2c, 0xfc, 0xff, 0xbe, 0x00, 0x00, /*  aX-  .XXa   */
0x00, 0xe3, 0xff, 0x13, 0x00, 0x00, 0xbd, 0xdd, 0xff, 0xdf, 0x00, 0x00, /*  XX   aOXO   */
0x00, 0xf8, 0xf9, 0x00, 0x00, 0x52, 0xff, 0x55, 0xff, 0xeb, 0x00, 0x00, /*  XX  -X-XX   */
0x00, 0xff, 0xf1, 0x00, 0x0c, 0xe0, 0xbd, 0x02, 0xff, 0xef, 0x00, 0x00, /*  XX  Xa XX   */
0x00, 0xff, 0xf0, 0x00, 0x96, 0xf7, 0x24, 0x04, 0xff, 0xf0, 0x00, 0x00, /*  XX oX. XX   */
0x00, 0xff, 0xf0, 0x40, 0xfe, 0x6d, 0x00, 0x0f, 0xff, 0xef, 0x00, 0x00, /*  XX-X+  XX   */
0x00, 0xfd, 0xf6, 0xdd, 0xab, 0x00, 0x00, 0x26, 0xff, 0xe8, 0x00, 0x00, /*  XXOa  .XX   */
0x00, 0xe7, 0xff, 0xc6, 0x0a, 0x00, 0x00, 0x59, 0xff, 0xc9, 0x00, 0x00, /*  XXO   -XO   */
0x00, 0x9a, 0xff, 0x54, 0x00, 0x00, 0x0d, 0xd1, 0xff, 0x7b, 0x00, 0x00, /*  oX-   OX+   */
0x00, 0x15, 0xe9, 0xf5, 0xa1, 0x9d, 0xe3, 0xff, 0xeb, 0x12, 0x00, 0x00, /*   XXaoXXX    */
0x00, 0x00, 0x18, 0xa7, 0xef, 0xff, 0xf7, 0xbf, 0x2d, 0x00, 0x00, 0x00, /*    aXXXa.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 49 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x74, 0xee, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +Xo      */
0x00, 0x00, 0x0a, 0xa7, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXXX      */
0x00, 0x06, 0xca, 0xff, 0xf0, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OXXXX      */
0x00, 0x19, 0xf7, 0xca, 0x24, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XO.XX      */
0x00, 0x00, 0x14, 0x01, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x93, 0xc0, 0xc0, 0xc0, 0xff, 0xfc, 0xc0, 0xc0, 0x95, 0x00, 0x00, /*  oOOOXXOOo   */
0x00, 0xd3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcd, 0x00, 0x00, /*  OXXXXXXXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 50 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x02, 0x68, 0xcb, 0xf4, 0xe4, 0xb5, 0x38, 0x00, 0x00, 0x00, /*    +OXXa.    */
0x00, 0x03, 0xb4, 0xff, 0xe9, 0x9d, 0xa8, 0xf5, 0xfd, 0x47, 0x00, 0x00, /*   aXXoaXX-   */
0x00, 0x51, 0xff, 0xc3, 0x10, 0x00, 0x00, 0x41, 0xff, 0xc0, 0x00, 0x00, /*  -XO   -XO   */
0x00, 0x12, 0x88, 0x14, 0x00, 0x00, 0x00, 0x08, 0xff, 0xe8, 0x00, 0x00, /*   o     XX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0xd5, 0x00, 0x00, /*        .XO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xd5, 0xff, 0x8e, 0x00, 0x00, /*        OXo   */
0x00, 0x00, 0x00, 0x00, 0x07, 0x77, 0xf3, 0xff, 0xcc, 0x10, 0x00, 0x00, /*      +XXO    */
0x00, 0x00, 0x00, 0x49, 0xe0, 0xff, 0xf9, 0x86, 0x09, 0x00, 0x00, 0x00, /*    -XXXo     */
0x00, 0x00, 0x63, 0xfe, 0xff, 0xa6, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +XXa.      */
0x00, 0x2d, 0xfa, 0xf9, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .XX-        */
0x00, 0xaa, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aX+         */
0x00, 0xef, 0xff, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xf8, 0xfd, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x8a, 0x0e, 0x00, /*  XXooooooo   */
0x00, 0xab, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x18, 0x00, /*  aXXXXXXXX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 51 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x04, 0x7c, 0xdc, 0xf9, 0xee, 0xbe, 0x51, 0x00, 0x00, 0x00, 0x00, /*   +OXXa-     */
0x00, 0x9e, 0xff, 0xdc, 0x97, 0xab, 0xf4, 0xff, 0x61, 0x00, 0x00, 0x00, /*  oXOoaXX+    */
0x03, 0xf6, 0xd8, 0x0e, 0x00, 0x00, 0x36, 0xff, 0xd2, 0x00, 0x00, 0x00, /*  XO   .XO    */
0x00, 0x34, 0x19, 0x00, 0x00, 0x00, 0x15, 0xff, 0xe5, 0x00, 0x00, 0x00, /*  .     XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x90, 0xff, 0xa6, 0x00, 0x00, 0x00, /*       oXa    */
0x00, 0x00, 0x00, 0x6c, 0xa4, 0xde, 0xf4, 0x9d, 0x0f, 0x00, 0x00, 0x00, /*    +aOXo     */
0x00, 0x00, 0x00, 0xc9, 0xff, 0xff, 0xdf, 0x6f, 0x01, 0x00, 0x00, 0x00, /*    OXXO+     */
0x00, 0x00, 0x00, 0x00, 0x17, 0x49, 0xdd, 0xff, 0x77, 0x00, 0x00, 0x00, /*      -OX+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0xff, 0xd9, 0x00, 0x00, 0x00, /*       .XO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xfa, 0xf7, 0x00, 0x00, 0x00, /*        XX    */
0x39, 0x69, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfe, 0xe8, 0x00, 0x00, 0x00, /* .+     XX    */
0xa5, 0xff, 0x8d, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xa0, 0x00, 0x00, 0x00, /* aXo   oXa    */
0x25, 0xe9, 0xff, 0xcc, 0x9a, 0xcc, 0xff, 0xe6, 0x1d, 0x00, 0x00, 0x00, /* .XXOoOXX     */
0x00, 0x19, 0x94, 0xe0, 0xfa, 0xe3, 0x99, 0x1a, 0x00, 0x00, 0x00, 0x00, /*   oXXXo      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 52 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa1, 0xf4, 0x94, 0x00, 0x00, 0x00, /*       aXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xe1, 0x00, 0x00, 0x00, /*      +XXX    */
0x00, 0x00, 0x00, 0x00, 0x47, 0xfd, 0xb6, 0xff, 0xee, 0x00, 0x00, 0x00, /*     -XaXX    */
0x00, 0x00, 0x00, 0x1e, 0xec, 0xd4, 0x0e, 0xff, 0xf0, 0x00, 0x00, 0x00, /*     XO XX    */
0x00, 0x00, 0x06, 0xc9, 0xf0, 0x25, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*    OX. XX    */
0x00, 0x00, 0x8e, 0xff, 0x53, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*   oX-  XX    */
0x00, 0x45, 0xff, 0xa1, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*  -Xa   XX    */
0x00, 0xd8, 0xff, 0xa4, 0x90, 0x90, 0x90, 0xff, 0xf9, 0x76, 0x00, 0x00, /*  OXaoooXX+   */
0x01, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, /*  XXXXXXXXX   */
0x00, 0x28, 0x3f, 0x20, 0x0e, 0x05, 0x01, 0xff, 0xef, 0x00, 0x00, 0x00, /*  ...   XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf1, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf6, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x04, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xd0, 0x01, 0x00, 0x00, /*        aO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 53 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x04, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x96, 0x00, 0x00, /*  OXXXXXXXo   */
0x02, 0xec, 0xf9, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x5a, 0x00, 0x00, /*  XXoooooo-   */
0x00, 0xeb, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xfa, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x30, 0xa8, 0xe9, 0xf9, 0xd2, 0x41, 0x00, 0x00, 0x00, /*  XX.aXXO-    */
0x00, 0xf9, 0xfc, 0xf9, 0xd0, 0x99, 0xb4, 0xfe, 0xfc, 0x34, 0x00, 0x00, /*  XXXOoaXX.   */
0x00, 0xce, 0xfe, 0x75, 0x00, 0x00, 0x00, 0x78, 0xff, 0xab, 0x00, 0x00, /*  OX+   +Xa   */
0x00, 0x13, 0x22, 0x00, 0x00, 0x00, 0x00, 0x17, 0xff, 0xdb, 0x00, 0x00, /*   .     XO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xe7, 0x00, 0x00, /*         XX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xce, 0x00, 0x00, /*        .XO   */
0x00, 0x56, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x79, 0xff, 0x93, 0x00, 0x00, /*  -     +Xo   */
0x17, 0xff, 0xd6, 0x13, 0x00, 0x00, 0x23, 0xeb, 0xfd, 0x2e, 0x00, 0x00, /*  XO   .XX.   */
0x00, 0x9e, 0xff, 0xe9, 0x9d, 0xa5, 0xf3, 0xff, 0x79, 0x00, 0x00, 0x00, /*  oXXoaXX+    */
0x00, 0x01, 0x69, 0xc9, 0xf0, 0xf5, 0xc5, 0x51, 0x00, 0x00, 0x00, 0x00, /*   +OXXO-     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 54 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x67, 0x8f, 0x3c, 0x00, 0x00, 0x00, /*      .+o.    */
0x00, 0x00, 0x00, 0x1d, 0xb9, 0xff, 0xff, 0xfa, 0x61, 0x00, 0x00, 0x00, /*     aXXX+    */
0x00, 0x00, 0x1f, 0xe4, 0xff, 0xb4, 0x4a, 0x0b, 0x00, 0x00, 0x00, 0x00, /*    XXa-      */
0x00, 0x00, 0xc4, 0xff, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OX+        */
0x00, 0x46, 0xff, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -Xa         */
0x00, 0x9d, 0xff, 0x47, 0x3e, 0x7b, 0x86, 0x5f, 0x0f, 0x00, 0x00, 0x00, /*  oX-.+o-     */
0x00, 0xd4, 0xfd, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x1b, 0x00, 0x00, /*  OXOXXXXX    */
0x00, 0xf1, 0xff, 0xed, 0x5d, 0x0e, 0x1d, 0xb1, 0xff, 0x9b, 0x00, 0x00, /*  XXX-  aXo   */
0x00, 0xfc, 0xfb, 0x31, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xdf, 0x00, 0x00, /*  XX.    XO   */
0x00, 0xf4, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xf9, 0x00, 0x00, /*  XX     XX   */
0x00, 0xd8, 0xfa, 0x05, 0x00, 0x00, 0x00, 0x02, 0xfa, 0xf2, 0x00, 0x00, /*  OX     XX   */
0x00, 0xa3, 0xff, 0x47, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xc2, 0x00, 0x00, /*  aX-   .XO   */
0x00, 0x49, 0xff, 0xcf, 0x0c, 0x00, 0x09, 0xca, 0xff, 0x50, 0x00, 0x00, /*  -XO   OX-   */
0x00, 0x00, 0xb0, 0xff, 0xdf, 0x9d, 0xda, 0xff, 0xae, 0x00, 0x00, 0x00, /*   aXOoOXa    */
0x00, 0x00, 0x06, 0x81, 0xde, 0xf9, 0xdb, 0x77, 0x05, 0x00, 0x00, 0x00, /*    oOXO+     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 55 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x05, 0xc8, 0xf4, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcd, 0x00, 0x00, /*  OXXXXXXXO   */
0x02, 0x9e, 0x9f, 0x93, 0x90, 0x90, 0x90, 0xb0, 0xff, 0xc9, 0x00, 0x00, /*  ooooooaXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9b, 0xff, 0x4a, 0x00, 0x00, /*        oX-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0xfb, 0xb6, 0x00, 0x00, 0x00, /*       .Xa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb9, 0xf7, 0x22, 0x00, 0x00, 0x00, /*       aX.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, /*      -X+     */
0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, /*      XO      */
0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oX-      */
0x00, 0x00, 0x00, 0x1e, 0xf6, 0xc9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XO       */
0x00, 0x00, 0x00, 0x9f, 0xff, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oX-       */
0x00, 0x00, 0x28, 0xfc, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .XO        */
0x00, 0x00, 0xab, 0xff, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aX-        */
0x00, 0x2f, 0xfe, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .XO         */
0x00, 0x45, 0xee, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -X-         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 56 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x33, 0xad, 0xe7, 0xf9, 0xe6, 0xab, 0x33, 0x00, 0x00, 0x00, /*   .aXXXa.    */
0x00, 0x3c, 0xf9, 0xff, 0xc6, 0x99, 0xd0, 0xff, 0xf9, 0x3c, 0x00, 0x00, /*  .XXOoOXX.   */
0x00, 0xc0, 0xff, 0x7b, 0x00, 0x00, 0x01, 0x90, 0xff, 0xbd, 0x00, 0x00, /*  OX+   oXa   */
0x00, 0xe8, 0xff, 0x10, 0x00, 0x00, 0x00, 0x11, 0xff, 0xe8, 0x00, 0x00, /*  XX     XX   */
0x00, 0xa9, 0xff, 0x88, 0x04, 0x00, 0x01, 0x78, 0xff, 0x99, 0x00, 0x00, /*  aXo   +Xo   */
0x00, 0x17, 0xcf, 0xff, 0xdf, 0x87, 0xcc, 0xfe, 0x94, 0x06, 0x00, 0x00, /*   OXOoOXo    */
0x00, 0x00, 0x2c, 0xec, 0xff, 0xff, 0xff, 0xfe, 0xa0, 0x14, 0x00, 0x00, /*   .XXXXXa    */
0x00, 0x23, 0xee, 0xff, 0x92, 0x20, 0x78, 0xfb, 0xff, 0xc1, 0x00, 0x00, /*  .XXo.+XXO   */
0x00, 0xac, 0xff, 0x86, 0x00, 0x00, 0x00, 0x67, 0xff, 0xf7, 0x00, 0x00, /*  aXo   +XX   */
0x00, 0xf3, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0x06, 0xfa, 0xfc, 0x00, 0x00, /*  XX     XX   */
0x00, 0xef, 0xfb, 0x07, 0x00, 0x00, 0x00, 0x0e, 0xfd, 0xe2, 0x00, 0x00, /*  XX     XX   */
0x00, 0xb1, 0xff, 0x87, 0x00, 0x00, 0x01, 0x8e, 0xff, 0x8d, 0x00, 0x00, /*  aXo   oXo   */
0x00, 0x2e, 0xf4, 0xff, 0xc1, 0x99, 0xd2, 0xff, 0xd4, 0x10, 0x00, 0x00, /*  .XXOoOXO    */
0x00, 0x00, 0x2c, 0xac, 0xe4, 0xfa, 0xdc, 0x8d, 0x12, 0x00, 0x00, 0x00, /*   .aXXOo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 57 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x08, 0x7f, 0xdd, 0xf8, 0xdd, 0x7e, 0x05, 0x00, 0x00, 0x00, /*    +OXO+     */
0x00, 0x04, 0xc0, 0xff, 0xd6, 0x9e, 0xdf, 0xff, 0xa3, 0x00, 0x00, 0x00, /*   OXOoOXa    */
0x00, 0x6e, 0xff, 0xc0, 0x06, 0x00, 0x0c, 0xcd, 0xff, 0x3a, 0x00, 0x00, /*  +XO   OX.   */
0x00, 0xcd, 0xff, 0x31, 0x00, 0x00, 0x00, 0x47, 0xff, 0x95, 0x00, 0x00, /*  OX.   -Xo   */
0x00, 0xf6, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x06, 0xfa, 0xcc, 0x00, 0x00, /*  XX     XO   */
0x00, 0xf2, 0xfe, 0x06, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xee, 0x00, 0x00, /*  XX     XX   */
0x00, 0xba, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x0f, 0xf6, 0xfa, 0x00, 0x00, /*  aX.    XX   */
0x00, 0x3e, 0xff, 0xd5, 0x33, 0x09, 0x3d, 0xcd, 0xff, 0xf4, 0x00, 0x00, /*  .XO. .OXX   */
0x00, 0x00, 0x77, 0xfe, 0xff, 0xff, 0xff, 0xee, 0xfe, 0xd9, 0x00, 0x00, /*   +XXXXXXO   */
0x00, 0x00, 0x00, 0x39, 0x84, 0x88, 0x68, 0x5a, 0xff, 0x9c, 0x00, 0x00, /*    .oo+-Xo   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xc8, 0xff, 0x3b, 0x00, 0x00, /*        OX.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x90, 0xff, 0xaa, 0x00, 0x00, 0x00, /*       oXa    */
0x00, 0x00, 0x00, 0x1c, 0x62, 0xce, 0xff, 0xb9, 0x09, 0x00, 0x00, 0x00, /*     +OXa     */
0x00, 0x06, 0xc5, 0xff, 0xff, 0xf8, 0x8c, 0x07, 0x00, 0x00, 0x00, 0x00, /*   OXXXo      */
0x00, 0x02, 0x7f, 0x88, 0x55, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +o-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 58 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0xcd, 0xf1, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OX.      */
0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX-      */
0x00, 0x00, 0x00, 0x00, 0xb8, 0xdf, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aO       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0xc2, 0xe9, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OX.      */
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX+      */
0x00, 0x00, 0x00, 0x00, 0xb9, 0xe5, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aX.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 59 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x4f, 0x71, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -+       */
0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX-      */
0x00, 0x00, 0x00, 0x00, 0xec, 0xff, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX-      */
0x00, 0x00, 0x00, 0x00, 0x37, 0x65, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .+       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x60, 0x89, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +o       */
0x00, 0x00, 0x00, 0x01, 0xee, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX-      */
0x00, 0x00, 0x00, 0x27, 0xff, 0xfd, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XX       */
0x00, 0x00, 0x00, 0x5b, 0xff, 0xcd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XO       */
0x00, 0x00, 0x00, 0x8f, 0xff, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXo       */
0x00, 0x00, 0x00, 0xbd, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aX-       */
0x00, 0x00, 0x00, 0xa7, 0xd7, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aO        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 60 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xd2, 0xb9, 0x00, 0x00, /*        .Oa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0xfb, 0xff, 0xbb, 0x00, 0x00, /*       +XXa   */
0x00, 0x00, 0x00, 0x00, 0x07, 0xa2, 0xff, 0xff, 0x92, 0x06, 0x00, 0x00, /*      aXXo    */
0x00, 0x00, 0x00, 0x16, 0xc5, 0xff, 0xf2, 0x53, 0x00, 0x00, 0x00, 0x00, /*     OXX-     */
0x00, 0x00, 0x2e, 0xe0, 0xff, 0xd6, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .XXO.      */
0x00, 0x54, 0xf3, 0xff, 0xaa, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXa        */
0x34, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .XX+         */
0x1d, 0xeb, 0xff, 0xcc, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXO         */
0x00, 0x1f, 0xd4, 0xff, 0xe0, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OXX.       */
0x00, 0x00, 0x11, 0xc5, 0xff, 0xe8, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OXX.      */
0x00, 0x00, 0x00, 0x0a, 0xb5, 0xff, 0xf0, 0x3e, 0x00, 0x00, 0x00, 0x00, /*     aXX.     */
0x00, 0x00, 0x00, 0x00, 0x05, 0xa7, 0xff, 0xf8, 0x60, 0x00, 0x00, 0x00, /*      aXX+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x85, 0xff, 0xff, 0x9f, 0x01, 0x00, /*       oXXo   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0xd2, 0xd9, 0x0b, 0x00, /*        -OO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 61 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x34, 0x00, 0x00, 0x00, /*  OXXXXXX.    */
0x00, 0x60, 0x8f, 0x90, 0x90, 0x90, 0x90, 0x8c, 0x15, 0x00, 0x00, 0x00, /*  +oooooo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x35, 0x00, 0x00, 0x00, /*  OXXXXXX.    */
0x00, 0x60, 0x90, 0x90, 0x90, 0x90, 0x90, 0x8c, 0x14, 0x00, 0x00, 0x00, /*  +oooooo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 62 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x28, 0xc9, 0xa0, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .Oa          */
0x1b, 0xdc, 0xff, 0xea, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXX.        */
0x00, 0x0d, 0xab, 0xff, 0xf9, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aXX-       */
0x00, 0x00, 0x01, 0x8d, 0xff, 0xfd, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXX+      */
0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0x79, 0x00, 0x00, 0x00, 0x00, /*     +XX+     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xfd, 0xff, 0x91, 0x02, 0x00, 0x00, /*      +XXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xf4, 0xff, 0xb6, 0x01, 0x00, /*       -XXa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x9f, 0xff, 0xf8, 0x0a, 0x00, /*        oXX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xb8, 0xff, 0xeb, 0x44, 0x00, 0x00, /*       aXX-   */
0x00, 0x00, 0x00, 0x00, 0x31, 0xdf, 0xff, 0xd1, 0x1f, 0x00, 0x00, 0x00, /*     .OXO     */
0x00, 0x00, 0x00, 0x61, 0xf7, 0xff, 0xaf, 0x0b, 0x00, 0x00, 0x00, 0x00, /*    +XXa      */
0x00, 0x0b, 0x9e, 0xff, 0xff, 0x86, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oXXo       */
0x0c, 0xd0, 0xff, 0xf4, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXX-        */
0x1c, 0xf3, 0xc9, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XO.         */
0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 63 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x36, 0xba, 0xf2, 0xe5, 0xb7, 0x3e, 0x00, 0x00, 0x00, 0x00, /*   .aXXa.     */
0x00, 0x43, 0xf8, 0xf9, 0xa5, 0xa9, 0xf6, 0xfe, 0x4e, 0x00, 0x00, 0x00, /*  -XXaaXX-    */
0x00, 0xdb, 0xfd, 0x49, 0x00, 0x00, 0x43, 0xff, 0xc3, 0x00, 0x00, 0x00, /*  OX-  -XO    */
0x00, 0x94, 0x76, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xe8, 0x00, 0x00, 0x00, /*  o+    XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xca, 0x00, 0x00, 0x00, /*       +XO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xfc, 0xf9, 0x45, 0x00, 0x00, 0x00, /*      +XX-    */
0x00, 0x00, 0x00, 0x00, 0x61, 0xff, 0xe7, 0x3c, 0x00, 0x00, 0x00, 0x00, /*     +XX.     */
0x00, 0x00, 0x00, 0x11, 0xf5, 0xf3, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX.      */
0x00, 0x00, 0x00, 0x55, 0xff, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -Xa       */
0x00, 0x00, 0x00, 0x1d, 0xab, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     a.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x78, 0xe4, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +Xo       */
0x00, 0x00, 0x00, 0xf4, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXX       */
0x00, 0x00, 0x00, 0x93, 0xf5, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXo       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 64 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x09, 0x86, 0xe4, 0xf8, 0xd8, 0x7a, 0x04, 0x00, 0x00, /*     oXXO+    */
0x00, 0x00, 0x05, 0xbf, 0xff, 0xc5, 0x96, 0xe4, 0xff, 0x9d, 0x00, 0x00, /*    aXOoXXo   */
0x00, 0x00, 0x80, 0xff, 0x8d, 0x00, 0x00, 0x16, 0xe9, 0xff, 0x2d, 0x00, /*   oXo   XX.  */
0x00, 0x0f, 0xf4, 0xde, 0x05, 0x00, 0x00, 0x00, 0x80, 0xff, 0x89, 0x00, /*   XO    oXo  */
0x00, 0x5f, 0xff, 0x7c, 0x01, 0x4a, 0x71, 0x35, 0x38, 0xff, 0xbf, 0x00, /*  -X+ -+..Xa  */
0x00, 0xa0, 0xff, 0x48, 0xc0, 0xff, 0xf9, 0xfd, 0x37, 0xff, 0xe0, 0x00, /*  aX-OXXX.XX  */
0x00, 0xce, 0xff, 0xa8, 0xff, 0x76, 0x01, 0x34, 0x01, 0xfd, 0xf4, 0x00, /*  OXaX+ . XX  */
0x00, 0xec, 0xfe, 0xdc, 0xff, 0x0d, 0x38, 0xff, 0x23, 0xf3, 0xfd, 0x00, /*  XXOX .X.XX  */
0x00, 0xfa, 0xf3, 0xe4, 0xff, 0x12, 0x5d, 0xff, 0x1f, 0xf3, 0xf2, 0x00, /*  XXXX -X XX  */
0x00, 0xf8, 0xfa, 0xb1, 0xff, 0xba, 0xdf, 0xfc, 0x61, 0xff, 0xcc, 0x00, /*  XXaXaOX+XO  */
0x00, 0xe2, 0xff, 0x3a, 0xc4, 0xf6, 0xb5, 0x92, 0xff, 0xff, 0x6a, 0x00, /*  XX.OXaoXX+  */
0x00, 0xab, 0xff, 0x4b, 0x00, 0x00, 0x00, 0x0c, 0x79, 0x69, 0x01, 0x00, /*  aX-    ++   */
0x00, 0x53, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x06, 0xc0, 0x2c, 0x00, /*  -Xa     O.  */
0x00, 0x03, 0xcd, 0xff, 0x50, 0x00, 0x00, 0x01, 0x90, 0xfb, 0x17, 0x00, /*   OX-   oX   */
0x00, 0x00, 0x24, 0xe6, 0xfb, 0xb1, 0x99, 0xd1, 0xff, 0x8a, 0x00, 0x00, /*   .XXaoOXo   */
0x00, 0x00, 0x00, 0x19, 0xa1, 0xed, 0xf7, 0xd4, 0x70, 0x01, 0x00, 0x00, /*     aXXO+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 65 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0xeb, 0x67, 0x00, 0x00, 0x00, 0x00, /*      .X+     */
0x00, 0x00, 0x00, 0x00, 0x08, 0xdd, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, /*      OXa     */
0x00, 0x00, 0x00, 0x00, 0x75, 0xf2, 0xd0, 0xe5, 0x00, 0x00, 0x00, 0x00, /*     +XOX     */
0x00, 0x00, 0x00, 0x0c, 0xec, 0x84, 0x8a, 0xff, 0x17, 0x00, 0x00, 0x00, /*     XooX     */
0x00, 0x00, 0x00, 0x74, 0xfa, 0x18, 0x56, 0xff, 0x4a, 0x00, 0x00, 0x00, /*    +X -X-    */
0x00, 0x00, 0x06, 0xe6, 0xa8, 0x00, 0x23, 0xff, 0x7e, 0x00, 0x00, 0x00, /*    Xa .X+    */
0x00, 0x00, 0x5f, 0xff, 0x45, 0x00, 0x00, 0xee, 0xb5, 0x00, 0x00, 0x00, /*   -X-  Xa    */
0x00, 0x01, 0xd0, 0xf6, 0x67, 0x7e, 0x8c, 0xe9, 0xeb, 0x00, 0x00, 0x00, /*   OX++oXX    */
0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x26, 0x00, 0x00, /*  aXXXXXXX.   */
0x00, 0xb9, 0xff, 0x61, 0x31, 0x15, 0x0b, 0x57, 0xff, 0x60, 0x00, 0x00, /*  aX+.  -X+   */
0x10, 0xf7, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xa0, 0x00, 0x00, /*  XO     Xa   */
0x66, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xe4, 0x00, 0x00, /* +X+     XX   */
0xa9, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa5, 0xff, 0x39, 0x00, /* aX.     aX.  */
0x7a, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xe1, 0x2e, 0x00, /* +a      .X.  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 66 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xc9, 0xff, 0xff, 0xff, 0xf7, 0xd7, 0x86, 0x0f, 0x00, 0x00, 0x00, /*  OXXXXOo     */
0x00, 0xff, 0xfc, 0xbc, 0xa0, 0x9e, 0xdf, 0xff, 0xdd, 0x18, 0x00, 0x00, /*  XXaaoOXO    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0x99, 0xff, 0x9b, 0x00, 0x00, /*  XX    oXo   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xde, 0x00, 0x00, /*  XX     XO   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x17, 0xff, 0xdd, 0x00, 0x00, /*  XX     XO   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x03, 0x9b, 0xff, 0x8f, 0x00, 0x00, /*  XX    oXo   */
0x00, 0xff, 0xf9, 0x90, 0x90, 0xa2, 0xde, 0xff, 0xab, 0x09, 0x00, 0x00, /*  XXooaOXa    */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x83, 0x01, 0x00, 0x00, /*  XXXXXXXo    */
0x00, 0xff, 0xf0, 0x00, 0x01, 0x2c, 0x75, 0xe9, 0xff, 0x87, 0x00, 0x00, /*  XX  .+XXo   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x24, 0xfc, 0xf4, 0x00, 0x00, /*  XX    .XX   */
0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x31, 0xff, 0xd1, 0x00, 0x00, /*  XX    .XO   */
0x03, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x48, 0xe7, 0xfe, 0x4f, 0x00, 0x00, /*  XX   -XX-   */
0x0a, 0xff, 0xfb, 0xbc, 0xc5, 0xed, 0xff, 0xf2, 0x5e, 0x00, 0x00, 0x00, /*  XXaOXXX-    */
0x05, 0xdd, 0xff, 0xf5, 0xdc, 0xb5, 0x71, 0x12, 0x00, 0x00, 0x00, 0x00, /*  OXXOa+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 67 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b, 0x37, 0x00, /*          -.  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xc8, 0xf7, 0xe6, 0xff, 0xd3, 0x00, /*      -OXXXO  */
0x00, 0x00, 0x00, 0x06, 0xa6, 0xff, 0xeb, 0x9e, 0xcc, 0xff, 0xee, 0x00, /*     aXXoOXX  */
0x00, 0x00, 0x00, 0xa0, 0xff, 0xb7, 0x10, 0x00, 0x02, 0xff, 0xe8, 0x00, /*    aXa   XX  */
0x00, 0x00, 0x4a, 0xff, 0xd5, 0x09, 0x00, 0x00, 0x00, 0x8c, 0x64, 0x00, /*   -XO    o+  */
0x00, 0x03, 0xdd, 0xfe, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OX.        */
0x00, 0x4c, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -Xa         */
0x00, 0x9a, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  oX-         */
0x00, 0xd0, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OX          */
0x00, 0xf1, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xf9, 0xfa, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xd9, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0d, 0x00, /*  OX.         */
0x00, 0x7d, 0xff, 0xcb, 0x0b, 0x00, 0x00, 0x04, 0x67, 0xf0, 0xa3, 0x00, /*  +XO    +Xa  */
0x00, 0x0a, 0xcb, 0xff, 0xde, 0x99, 0xab, 0xeb, 0xff, 0xda, 0x24, 0x00, /*   OXOoaXXO.  */
0x00, 0x00, 0x0d, 0x8a, 0xe7, 0xfa, 0xea, 0xbe, 0x6f, 0x0a, 0x00, 0x00, /*    oXXXa+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 68 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xc4, 0xf2, 0xce, 0x91, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXOo.       */
0x00, 0xff, 0xfe, 0xf3, 0xff, 0xff, 0xbd, 0x2a, 0x00, 0x00, 0x00, 0x00, /*  XXXXXa.     */
0x00, 0xff, 0xf6, 0x0d, 0x69, 0xdf, 0xff, 0xf5, 0x4a, 0x00, 0x00, 0x00, /*  XX +OXX-    */
0x00, 0xff, 0xf5, 0x00, 0x00, 0x06, 0x8b, 0xff, 0xfa, 0x33, 0x00, 0x00, /*  XX   oXX.   */
0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x79, 0xff, 0xd6, 0x04, 0x00, /*  XX    +XO   */
0x00, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc4, 0xff, 0x54, 0x00, /*  XX     OX-  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b, 0xff, 0xa2, 0x00, /*  XX     -Xa  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xd1, 0x00, /*  XX     .XO  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xe8, 0x00, /*  XX      XX  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xde, 0x00, /*  XX     .XO  */
0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xff, 0xab, 0x00, /*  XX     +Xa  */
0x03, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x17, 0xe2, 0xff, 0x42, 0x00, /*  XX     XX-  */
0x0a, 0xff, 0xff, 0xf8, 0xbe, 0xa2, 0x97, 0xe0, 0xff, 0x93, 0x00, 0x00, /*  XXXaaoXXo   */
0x05, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xdc, 0x67, 0x01, 0x00, 0x00, /*  XXXXXXO+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 69 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xcb, 0xdb, 0xd6, 0xf4, 0xff, 0xff, 0xff, 0xfc, 0xea, 0x50, 0x00, /*  OOOXXXXXX-  */
0x00, 0xff, 0xfd, 0xc0, 0xa1, 0x96, 0x94, 0x9f, 0xa9, 0xb1, 0x41, 0x00, /*  XXOaoooaa-  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x1a, 0x00, /*  XXXXXXXXX   */
0x00, 0xff, 0xf9, 0x8c, 0x81, 0x71, 0x5f, 0x4c, 0x39, 0x21, 0x00, 0x00, /*  XXoo+--..   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xfd, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xec, 0xff, 0xa9, 0x95, 0x90, 0x91, 0x98, 0xad, 0xd1, 0x3d, 0x00, /*  XXaooooaO.  */
0x00, 0x70, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x45, 0x00, /*  +XXXXXXXX-  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 70 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xc9, 0xde, 0xc8, 0xe6, 0xf5, 0xfd, 0xfc, 0xf4, 0xe4, 0x47, 0x00, /*  OOOXXXXXX-  */
0x00, 0xff, 0xfc, 0xc2, 0xb5, 0xa9, 0x9e, 0x99, 0x95, 0x8d, 0x1d, 0x00, /*  XXOaaoooo   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xfe, 0xed, 0xf8, 0xfe, 0xf7, 0xe8, 0xcf, 0x75, 0x00, 0x00, /*  XXXXXXXO+   */
0x00, 0xff, 0xf9, 0x97, 0x92, 0x90, 0x90, 0x91, 0x9c, 0x6d, 0x00, 0x00, /*  XXoooooo+   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x03, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x09, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x05, 0xdc, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  Oa          */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 71 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xcf, 0xf8, 0xdd, 0x8d, 0x1b, 0x00, /*      +OXOo   */
0x00, 0x00, 0x00, 0x06, 0xac, 0xff, 0xe8, 0x9d, 0xcc, 0xff, 0xcd, 0x00, /*     aXXoOXO  */
0x00, 0x00, 0x00, 0x9f, 0xff, 0xb0, 0x0d, 0x00, 0x00, 0x48, 0x55, 0x00, /*    oXa   --  */
0x00, 0x00, 0x46, 0xff, 0xd3, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -XO        */
0x00, 0x02, 0xd8, 0xfe, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OX.        */
0x00, 0x48, 0xff, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -Xa         */
0x00, 0x97, 0xff, 0x56, 0x00, 0x00, 0x00, 0x0d, 0x1e, 0x28, 0x12, 0x00, /*  oX-     .   */
0x00, 0xce, 0xff, 0x16, 0x68, 0xd3, 0xf7, 0xff, 0xff, 0xff, 0xc3, 0x00, /*  OX +OXXXXO  */
0x00, 0xf0, 0xf9, 0x00, 0xcf, 0xc8, 0x93, 0x7c, 0x80, 0xff, 0x6b, 0x00, /*  XX OOo+oX+  */
0x00, 0xfa, 0xfa, 0x01, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xff, 0x2e, 0x00, /*  XX     +X.  */
0x00, 0xde, 0xff, 0x3d, 0x00, 0x00, 0x00, 0x18, 0xee, 0xc9, 0x00, 0x00, /*  OX.    XO   */
0x00, 0x88, 0xff, 0xd7, 0x0b, 0x00, 0x0e, 0xc2, 0xfc, 0x36, 0x00, 0x00, /*  oXO   OX.   */
0x00, 0x0f, 0xd3, 0xff, 0xdc, 0x9a, 0xde, 0xfe, 0x63, 0x00, 0x00, 0x00, /*   OXOoOX+    */
0x00, 0x00, 0x11, 0x8f, 0xe8, 0xf3, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, /*    oXXO.     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 72 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xcc, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xb6, 0x00, 0x00, /*  Oa     Oa   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x07, 0x15, 0x2c, 0x4a, 0x6b, 0xff, 0xf0, 0x00, 0x00, /*  XX  .-+XX   */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, /*  XXXXXXXXX   */
0x00, 0xff, 0xf9, 0x89, 0x71, 0x50, 0x2d, 0x0c, 0xff, 0xf0, 0x00, 0x00, /*  XXo+-. XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xd7, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xad, 0x00, 0x00, /*  Oa     Oa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 73 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xc4, 0xff, 0xfd, 0xfa, 0xf5, 0xef, 0xe5, 0xd9, 0xc7, 0x5b, 0x00, /*  OXXXXXXOO-  */
0x00, 0x62, 0x8f, 0x90, 0x90, 0xff, 0xf9, 0x91, 0x95, 0xa1, 0x52, 0x00, /*  +oooXXooa-  */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x62, 0x90, 0x90, 0x90, 0xff, 0xf9, 0x90, 0x90, 0x8f, 0x4a, 0x00, /*  +oooXXooo-  */
0x00, 0xcd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x00, /*  OXXXXXXXXa  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0b, 0x06, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 74 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x50, 0xf6, 0xfe, 0xfc, 0xf7, 0xf0, 0xe6, 0xda, 0xc8, 0x73, 0x00, 0x00, /* -XXXXXXOO+   */
0x22, 0x89, 0x90, 0x90, 0x90, 0xff, 0xf9, 0x93, 0x9e, 0x6b, 0x00, 0x00, /* .ooooXXoo+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x02, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0xa3, 0xbf, 0x00, 0x00, 0x03, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, /* aa   XX      */
0xc3, 0xf9, 0x0e, 0x00, 0x0d, 0xff, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, /* OX   XO      */
0x5c, 0xff, 0x8e, 0x00, 0x2c, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, /* -Xo .Xa      */
0x00, 0xa0, 0xff, 0xc7, 0xc2, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXOOX-      */
0x00, 0x01, 0x64, 0xcd, 0xf5, 0xb1, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +OXa       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 75 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, /*              */
0x00, 0xcc, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xd5, 0x95, 0x00, 0x00, /*  Oa     Oo   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x22, 0xe1, 0xfd, 0x4a, 0x00, 0x00, /*  XX   .XX-   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x23, 0xe3, 0xfe, 0x62, 0x00, 0x00, 0x00, /*  XX  .XX+    */
0x00, 0xff, 0xf0, 0x00, 0x24, 0xe3, 0xff, 0x6b, 0x00, 0x00, 0x00, 0x00, /*  XX .XX+     */
0x00, 0xff, 0xf0, 0x24, 0xe3, 0xff, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX.XX+      */
0x00, 0xff, 0xf7, 0xe3, 0xff, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXX+       */
0x00, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXo        */
0x00, 0xff, 0xfd, 0xfe, 0xe6, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXX.       */
0x00, 0xff, 0xf0, 0x73, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX+XX.      */
0x00, 0xff, 0xf0, 0x00, 0x7e, 0xff, 0xec, 0x32, 0x00, 0x00, 0x00, 0x00, /*  XX +XX.     */
0x01, 0xff, 0xf0, 0x00, 0x00, 0x78, 0xff, 0xf0, 0x38, 0x00, 0x00, 0x00, /*  XX  +XX.    */
0x03, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xf2, 0x3c, 0x00, 0x00, /*  XX   +XX.   */
0x09, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfc, 0xf2, 0x29, 0x00, /*  XX    -XX.  */
0x05, 0xdc, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xfa, 0x45, 0x00, /*  Oa     -X-  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 76 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xcb, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  Oa          */
0x00, 0xff, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x0a, 0xff, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x18, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x26, 0xff, 0xcd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .XO          */
0x34, 0xff, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .Xa          */
0x4b, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x12, 0x00, 0x00, /* -Xo          */
0x65, 0xff, 0xcf, 0x92, 0x9d, 0xb0, 0xc6, 0xe3, 0xfe, 0xe9, 0x00, 0x00, /* +XOooaOXXX   */
0x4c, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xef, 0xd7, 0x91, 0x00, 0x00, /* -XXXXXXXOo   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 77 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x6e, 0xf0, 0x8a, 0x00, 0x00, 0x30, 0xee, 0xe1, 0x08, 0x00, /*   +Xo  .XX   */
0x00, 0x00, 0xea, 0xff, 0xea, 0x00, 0x00, 0x85, 0xfc, 0xff, 0x28, 0x00, /*   XXX  oXX.  */
0x00, 0x15, 0xff, 0xfa, 0xff, 0x16, 0x00, 0xbb, 0xd7, 0xff, 0x3c, 0x00, /*   XXX  aOX.  */
0x00, 0x34, 0xff, 0xb6, 0xff, 0x3c, 0x00, 0xe9, 0xaa, 0xff, 0x4f, 0x00, /*  .XaX. XaX-  */
0x00, 0x4e, 0xff, 0x6d, 0xff, 0x5f, 0x0d, 0xff, 0x82, 0xfe, 0x62, 0x00, /*  -X+X- XoX+  */
0x00, 0x64, 0xff, 0x34, 0xff, 0x80, 0x30, 0xff, 0x66, 0xfc, 0x75, 0x00, /*  +X.Xo.X+X+  */
0x00, 0x79, 0xff, 0x0c, 0xfe, 0x9f, 0x52, 0xff, 0x4b, 0xf8, 0x88, 0x00, /*  +X Xo-X-Xo  */
0x00, 0x8e, 0xff, 0x00, 0xe2, 0xbd, 0x6e, 0xff, 0x2e, 0xf4, 0x9b, 0x00, /*  oX Xa+X.Xo  */
0x00, 0xa2, 0xff, 0x00, 0xba, 0xdb, 0x87, 0xff, 0x10, 0xee, 0xaf, 0x00, /*  aX aOoX Xa  */
0x00, 0xbb, 0xfc, 0x00, 0x90, 0xf7, 0x9f, 0xf2, 0x00, 0xe5, 0xc3, 0x00, /*  aX oXoX XO  */
0x00, 0xd5, 0xf7, 0x00, 0x66, 0xff, 0xcb, 0xd4, 0x00, 0xdb, 0xd9, 0x00, /*  OX +XOO OO  */
0x00, 0xed, 0xf2, 0x00, 0x3a, 0xff, 0xf9, 0xb2, 0x00, 0xca, 0xf3, 0x00, /*  XX .XXa OX  */
0x00, 0xfc, 0xed, 0x00, 0x0d, 0xfe, 0xff, 0x85, 0x00, 0xab, 0xff, 0x0d, /*  XX  XXo aX  */
0x00, 0xc9, 0x9e, 0x00, 0x00, 0xb7, 0xee, 0x36, 0x00, 0x3a, 0x9e, 0x03, /*  Oo  aX. .o  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 78 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xb0, 0xfa, 0x66, 0x00, 0x00, 0x00, 0x06, 0xdc, 0xba, 0x00, 0x00, /*  aX+    Oa   */
0x00, 0xfe, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xf6, 0x00, 0x00, /*  XXO    XX   */
0x00, 0xff, 0xfd, 0xff, 0x34, 0x00, 0x00, 0x00, 0xfc, 0xfd, 0x00, 0x00, /*  XXX.   XX   */
0x00, 0xff, 0xf0, 0xcd, 0x9d, 0x00, 0x00, 0x00, 0xf6, 0xff, 0x00, 0x00, /*  XXOo   XX   */
0x00, 0xff, 0xf0, 0x6a, 0xf6, 0x14, 0x00, 0x00, 0xf2, 0xff, 0x00, 0x00, /*  XX+X   XX   */
0x00, 0xff, 0xf0, 0x0c, 0xf0, 0x7b, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, /*  XX X+  XX   */
0x00, 0xff, 0xf0, 0x00, 0x87, 0xe7, 0x06, 0x00, 0xf0, 0xff, 0x00, 0x00, /*  XX oX  XX   */
0x00, 0xff, 0xf0, 0x00, 0x17, 0xf6, 0x63, 0x00, 0xf0, 0xff, 0x00, 0x00, /*  XX  X+ XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x90, 0xd7, 0x01, 0xf0, 0xff, 0x00, 0x00, /*  XX  oO XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x18, 0xf5, 0x51, 0xf0, 0xff, 0x00, 0x00, /*  XX   X-XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x8a, 0xcc, 0xf0, 0xfe, 0x00, 0x00, /*  XX   oOXX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x13, 0xf2, 0xff, 0xfb, 0x00, 0x00, /*  XX    XXX   */
0x00, 0xff, 0xef, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xf2, 0x00, 0x00, /*  XX    oXX   */
0x00, 0xd1, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x11, 0xdf, 0xb7, 0x00, 0x00, /*  Oa     Oa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 79 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x56, 0xc4, 0xf1, 0xec, 0x99, 0x11, 0x00, 0x00, 0x00, /*    -OXXo     */
0x00, 0x00, 0x8e, 0xff, 0xef, 0xa2, 0xce, 0xff, 0xd0, 0x08, 0x00, 0x00, /*   oXXaOXO    */
0x00, 0x42, 0xff, 0xf8, 0x2b, 0x00, 0x04, 0xbb, 0xff, 0x6f, 0x00, 0x00, /*  -XX.  aX+   */
0x00, 0xa2, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xc2, 0x00, 0x00, /*  aXo   .XO   */
0x00, 0xdc, 0xff, 0x52, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xe9, 0x00, 0x00, /*  OX-    XX   */
0x00, 0xf6, 0xff, 0x29, 0x00, 0x00, 0x00, 0x00, 0xfd, 0xf6, 0x00, 0x00, /*  XX.    XX   */
0x00, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0xf4, 0xfe, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfb, 0xff, 0x00, 0x00, /*  XX     XX   */
0x00, 0xf2, 0xfb, 0x01, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf4, 0x00, 0x00, /*  XX     XX   */
0x00, 0xcc, 0xff, 0x28, 0x00, 0x00, 0x00, 0x54, 0xff, 0xc6, 0x00, 0x00, /*  OX.   -XO   */
0x00, 0x77, 0xff, 0x8c, 0x00, 0x00, 0x19, 0xdc, 0xff, 0x64, 0x00, 0x00, /*  +Xo   OX+   */
0x00, 0x09, 0xd4, 0xff, 0xaf, 0xa6, 0xf2, 0xff, 0xc4, 0x04, 0x00, 0x00, /*   OXaaXXO    */
0x00, 0x00, 0x16, 0xa1, 0xed, 0xf8, 0xdb, 0x88, 0x0b, 0x00, 0x00, 0x00, /*    aXXOo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 80 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x11, 0xcf, 0xf6, 0xff, 0xff, 0xfa, 0xdf, 0x96, 0x1b, 0x00, 0x00, 0x00, /*  OXXXXOo     */
0x13, 0xff, 0xfb, 0xac, 0x98, 0x98, 0xd4, 0xff, 0xe9, 0x21, 0x00, 0x00, /*  XXaooOXX.   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x01, 0x8a, 0xff, 0xa3, 0x00, 0x00, /*  XX    oXa   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x13, 0xff, 0xe0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe4, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x31, 0xff, 0xb9, 0x00, 0x00, /*  XX    .Xa   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0a, 0xbb, 0xff, 0x4c, 0x00, 0x00, /*  XX    aX-   */
0x00, 0xff, 0xfd, 0xb1, 0x95, 0xa4, 0xe8, 0xff, 0xad, 0x00, 0x00, 0x00, /*  XXaoaXXa    */
0x00, 0xff, 0xff, 0xe3, 0xf6, 0xfb, 0xda, 0x78, 0x05, 0x00, 0x00, 0x00, /*  XXXXXO+     */
0x00, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX.         */
0x00, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX.         */
0x00, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX.         */
0x00, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX.         */
0x00, 0xca, 0xd9, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OO          */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 81 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x31, 0xb2, 0xec, 0xe7, 0xa7, 0x18, 0x00, 0x00, 0x00, /*    .aXXa     */
0x00, 0x00, 0x48, 0xf8, 0xe8, 0x9f, 0xd0, 0xff, 0xd6, 0x08, 0x00, 0x00, /*   -XXoOXO    */
0x00, 0x0b, 0xe6, 0xea, 0x19, 0x00, 0x05, 0xc1, 0xff, 0x66, 0x00, 0x00, /*   XX   OX+   */
0x00, 0x57, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x48, 0xff, 0xb3, 0x00, 0x00, /*  -X+   -Xa   */
0x00, 0x98, 0xff, 0x34, 0x00, 0x00, 0x00, 0x14, 0xff, 0xdb, 0x00, 0x00, /*  oX.    XO   */
0x00, 0xc5, 0xff, 0x0d, 0x00, 0x00, 0x00, 0x03, 0xff, 0xef, 0x00, 0x00, /*  OX     XX   */
0x00, 0xe3, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xf9, 0x00, 0x00, /*  XX     XX   */
0x00, 0xf5, 0xed, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf2, 0xfe, 0x00, 0x00, /*  XX     XX   */
0x00, 0xfd, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xf7, 0x00, 0x00, /*  XX     XX   */
0x00, 0xee, 0xfe, 0x05, 0x18, 0x8b, 0x00, 0x09, 0xff, 0xe7, 0x00, 0x00, /*  XX  o  XX   */
0x00, 0xc6, 0xff, 0x41, 0x4b, 0xff, 0x3e, 0x37, 0xff, 0xbd, 0x00, 0x00, /*  OX--X..Xa   */
0x00, 0x69, 0xff, 0xc2, 0x10, 0xef, 0xb2, 0xb4, 0xff, 0x6a, 0x00, 0x00, /*  +XO XaaX+   */
0x00, 0x04, 0xc5, 0xff, 0xd0, 0xd8, 0xff, 0xff, 0xc4, 0x06, 0x00, 0x00, /*   OXOOXXO    */
0x00, 0x00, 0x0d, 0x8f, 0xe9, 0xfa, 0xfa, 0xef, 0x0e, 0x00, 0x00, 0x00, /*    oXXXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0x8d, 0x00, 0x00, 0x00, /*       -Xo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc6, 0xff, 0x51, 0x00, 0x00, /*        OX-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0xf9, 0xe9, 0x00, 0x00, /*        .XX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x6b, 0x00, 0x00, /*         -+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 82 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xc2, 0xff, 0xf3, 0xd7, 0x9f, 0x4b, 0x01, 0x00, 0x00, 0x00, 0x00, /*  OXXOo-      */
0x00, 0xff, 0xfb, 0xe1, 0xff, 0xff, 0xff, 0xcd, 0x27, 0x00, 0x00, 0x00, /*  XXXXXXO.    */
0x00, 0xff, 0xf0, 0x00, 0x2e, 0x92, 0xf9, 0xff, 0xea, 0x1f, 0x00, 0x00, /*  XX .oXXX    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x24, 0xdb, 0xff, 0xa6, 0x00, 0x00, /*  XX   .OXa   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xe7, 0x00, 0x00, /*  XX    .XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfb, 0xec, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf5, 0x32, 0x34, 0x45, 0x6f, 0xd3, 0xff, 0x84, 0x00, 0x00, /*  XX..-+OXo   */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xc4, 0x63, 0x01, 0x00, 0x00, /*  XXXXXXO+    */
0x00, 0xff, 0xfb, 0xf0, 0xff, 0xa0, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXa       */
0x00, 0xff, 0xf6, 0x14, 0xab, 0xff, 0xde, 0x33, 0x00, 0x00, 0x00, 0x00, /*  XX aXO.     */
0x00, 0xff, 0xff, 0x06, 0x00, 0x77, 0xfd, 0xf7, 0x59, 0x00, 0x00, 0x00, /*  XX  +XX-    */
0x01, 0xff, 0xff, 0x1d, 0x00, 0x00, 0x52, 0xf9, 0xfd, 0x58, 0x00, 0x00, /*  XX   -XX-   */
0x0a, 0xff, 0xff, 0x37, 0x00, 0x00, 0x00, 0x4c, 0xfb, 0xf6, 0x1e, 0x00, /*  XX.   -XX   */
0x07, 0xd8, 0xdc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xf3, 0x28, 0x00, /*  OO.    -X.  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 83 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x03, 0x5c, 0xba, 0xe2, 0xfb, 0xf1, 0xd1, 0x54, 0x00, 0x00, /*    -aXXXO-   */
0x00, 0x0c, 0xbc, 0xff, 0xe7, 0xa6, 0x93, 0xa3, 0xd3, 0x9d, 0x00, 0x00, /*   aXXaoaOo   */
0x00, 0x91, 0xff, 0x93, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  oXo         */
0x00, 0xe8, 0xfb, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xe6, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX-         */
0x00, 0x6c, 0xff, 0xfc, 0xb7, 0x96, 0x7d, 0x3b, 0x00, 0x00, 0x00, 0x00, /*  +XXao+.     */
0x00, 0x00, 0x4c, 0xaa, 0xde, 0xfd, 0xff, 0xff, 0xb3, 0x07, 0x00, 0x00, /*   -aOXXXa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x65, 0xe9, 0xff, 0x8b, 0x00, 0x00, /*       +XXo   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0xff, 0xe5, 0x00, 0x00, /*        .XX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf7, 0xf8, 0x00, 0x00, /*         XX   */
0x0b, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xcd, 0x00, 0x00, /*  .     .XO   */
0x80, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x3a, 0xe1, 0xff, 0x4b, 0x00, 0x00, /* oX+   .XX-   */
0x2a, 0xf3, 0xff, 0xcf, 0xaa, 0xce, 0xff, 0xfd, 0x76, 0x00, 0x00, 0x00, /* .XXOaOXX+    */
0x00, 0x26, 0xa4, 0xe7, 0xf8, 0xde, 0x9f, 0x33, 0x00, 0x00, 0x00, 0x00, /*  .aXXOo.     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 84 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x19, 0x23, 0x14, 0x0c, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, /*   .          */
0x00, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x00, /*  XXXXXXXXXO  */
0x00, 0x4e, 0x87, 0x8e, 0x90, 0xff, 0xf9, 0x90, 0x90, 0x90, 0x59, 0x00, /*  -oooXXooo-  */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x05, 0xe0, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, /*      Xa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 85 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xc1, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xba, 0x00, /*  Oa      Oa  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xef, 0x00, /*  XX      XX  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, /*  XX      XX  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, /*  XX      XX  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, /*  XX      XX  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, /*  XX      XX  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, /*  XX      XX  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, /*  XX      XX  */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xec, 0x00, /*  XX      XX  */
0x00, 0xf4, 0xfd, 0x04, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xff, 0xd0, 0x00, /*  XX      XO  */
0x00, 0xc8, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0x95, 0x00, /*  OX-    -Xo  */
0x00, 0x68, 0xff, 0xcc, 0x0e, 0x00, 0x00, 0x1c, 0xd9, 0xf7, 0x27, 0x00, /*  +XO    OX.  */
0x00, 0x03, 0xae, 0xff, 0xe5, 0xa1, 0xad, 0xf1, 0xf9, 0x5a, 0x00, 0x00, /*   aXXaaXX-   */
0x00, 0x00, 0x02, 0x6b, 0xd2, 0xf8, 0xe9, 0xa4, 0x2e, 0x00, 0x00, 0x00, /*    +OXXa.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 86 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x7c, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0xd8, 0x28, 0x00, /* +a      .O.  */
0xa8, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa7, 0xff, 0x39, 0x00, /* aX      aX.  */
0x6f, 0xff, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf2, 0xde, 0x01, 0x00, /* +X+     XO   */
0x22, 0xff, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xff, 0x82, 0x00, 0x00, /* .Xa    -Xo   */
0x00, 0xd2, 0xfa, 0x0f, 0x00, 0x00, 0x00, 0x9c, 0xff, 0x28, 0x00, 0x00, /*  OX    oX.   */
0x00, 0x81, 0xff, 0x58, 0x00, 0x00, 0x03, 0xea, 0xcf, 0x00, 0x00, 0x00, /*  oX-   XO    */
0x00, 0x2e, 0xff, 0xa7, 0x00, 0x00, 0x40, 0xff, 0x77, 0x00, 0x00, 0x00, /*  .Xa  -X+    */
0x00, 0x00, 0xd9, 0xf1, 0x06, 0x00, 0x91, 0xff, 0x20, 0x00, 0x00, 0x00, /*   OX  oX.    */
0x00, 0x00, 0x83, 0xff, 0x47, 0x01, 0xe2, 0xc9, 0x00, 0x00, 0x00, 0x00, /*   oX- XO     */
0x00, 0x00, 0x2d, 0xff, 0x98, 0x37, 0xff, 0x73, 0x00, 0x00, 0x00, 0x00, /*   .Xo.X+     */
0x00, 0x00, 0x00, 0xd4, 0xe8, 0x8d, 0xff, 0x21, 0x00, 0x00, 0x00, 0x00, /*    OXoX.     */
0x00, 0x00, 0x00, 0x7b, 0xff, 0xf7, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +XXO      */
0x00, 0x00, 0x00, 0x1f, 0xfe, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXo      */
0x00, 0x00, 0x00, 0x00, 0x9a, 0xee, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oX.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 87 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, /*              */
0xd4, 0x54, 0x00, 0x06, 0xd6, 0xd7, 0x03, 0x00, 0xaf, 0xb7, 0x00, 0x1e, /* O-  OO  aa   */
0xff, 0x84, 0x00, 0x32, 0xff, 0xff, 0x27, 0x00, 0xfe, 0xeb, 0x00, 0x10, /* Xo .XX. XX   */
0xff, 0x93, 0x00, 0x5a, 0xf8, 0xff, 0x49, 0x00, 0xff, 0xe3, 0x00, 0x00, /* Xo -XX- XX   */
0xf8, 0xa6, 0x00, 0x7f, 0xcf, 0xfb, 0x69, 0x00, 0xff, 0xd0, 0x00, 0x00, /* Xa +OX+ XO   */
0xe2, 0xba, 0x00, 0xa1, 0xb4, 0xe7, 0x86, 0x01, 0xff, 0xba, 0x00, 0x00, /* Xa aaXo Xa   */
0xcc, 0xcf, 0x00, 0xc0, 0x9a, 0xd1, 0xa2, 0x06, 0xff, 0xa4, 0x00, 0x00, /* OO OoOa Xa   */
0xb5, 0xe4, 0x00, 0xde, 0x80, 0xbb, 0xc0, 0x0b, 0xff, 0x8d, 0x00, 0x00, /* aX OoaO Xo   */
0x9e, 0xf9, 0x02, 0xfa, 0x65, 0xa3, 0xdf, 0x17, 0xff, 0x73, 0x00, 0x00, /* oX X+aO X+   */
0x86, 0xff, 0x2a, 0xff, 0x4b, 0x8c, 0xfb, 0x2b, 0xff, 0x59, 0x00, 0x00, /* oX.X-oX.X-   */
0x6d, 0xff, 0x5f, 0xff, 0x2f, 0x74, 0xff, 0x65, 0xff, 0x3e, 0x00, 0x00, /* +X-X.+X+X.   */
0x4f, 0xff, 0x94, 0xff, 0x11, 0x58, 0xff, 0xab, 0xff, 0x22, 0x00, 0x00, /* -XoX -XaX.   */
0x2c, 0xff, 0xcd, 0xf1, 0x00, 0x34, 0xff, 0xf3, 0xfc, 0x06, 0x00, 0x00, /* .XOX .XXX    */
0x08, 0xfc, 0xfc, 0xca, 0x00, 0x0a, 0xfc, 0xff, 0xd4, 0x00, 0x00, 0x00, /*  XXO  XXO    */
0x00, 0xbe, 0xfc, 0x73, 0x00, 0x00, 0xa8, 0xef, 0x58, 0x00, 0x00, 0x00, /*  aX+  aX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 88 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x19, 0x85, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x64, 0x00, 0x00, /*  o      ++   */
0x56, 0xff, 0xca, 0x03, 0x00, 0x00, 0x00, 0x3c, 0xfe, 0xbb, 0x00, 0x00, /* -XO    .Xa   */
0x05, 0xd2, 0xff, 0x72, 0x00, 0x00, 0x02, 0xd0, 0xff, 0x3d, 0x00, 0x00, /*  OX+   OX.   */
0x00, 0x33, 0xfb, 0xf3, 0x1c, 0x00, 0x65, 0xff, 0x9f, 0x00, 0x00, 0x00, /*  .XX  +Xo    */
0x00, 0x00, 0x87, 0xff, 0xac, 0x0c, 0xe7, 0xed, 0x15, 0x00, 0x00, 0x00, /*   oXa XX     */
0x00, 0x00, 0x07, 0xd6, 0xff, 0xba, 0xff, 0x67, 0x00, 0x00, 0x00, 0x00, /*    OXaX+     */
0x00, 0x00, 0x00, 0x38, 0xfd, 0xff, 0xcb, 0x02, 0x00, 0x00, 0x00, 0x00, /*    .XXO      */
0x00, 0x00, 0x00, 0x1e, 0xf6, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXo      */
0x00, 0x00, 0x00, 0xb1, 0xfd, 0xe8, 0xf6, 0x20, 0x00, 0x00, 0x00, 0x00, /*    aXXX.     */
0x00, 0x00, 0x54, 0xff, 0x94, 0x57, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, /*   -Xo-Xa     */
0x00, 0x10, 0xe7, 0xea, 0x10, 0x01, 0xca, 0xff, 0x44, 0x00, 0x00, 0x00, /*   XX  OX-    */
0x00, 0x9c, 0xff, 0x64, 0x00, 0x00, 0x3c, 0xff, 0xd7, 0x06, 0x00, 0x00, /*  oX+  .XO    */
0x40, 0xff, 0xcf, 0x02, 0x00, 0x00, 0x00, 0xa6, 0xff, 0x7e, 0x00, 0x00, /* -XO    aX+   */
0x9f, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe5, 0xf4, 0x02, 0x00, /* oX.     XX   */
0x22, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x49, 0x00, 0x00, /* .-       -   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 89 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x68, 0xcd, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xe0, 0x0c, 0x00, /* +O      oX   */
0x97, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x16, 0xf7, 0xfa, 0x0f, 0x00, /* oX+     XX   */
0x3b, 0xff, 0xd8, 0x02, 0x00, 0x00, 0x00, 0x83, 0xff, 0x9d, 0x00, 0x00, /* .XO    oXo   */
0x00, 0xbb, 0xff, 0x59, 0x00, 0x00, 0x0b, 0xec, 0xfd, 0x24, 0x00, 0x00, /*  aX-   XX.   */
0x00, 0x2c, 0xfc, 0xe1, 0x09, 0x00, 0x72, 0xff, 0xa1, 0x00, 0x00, 0x00, /*  .XX  +Xa    */
0x00, 0x00, 0x96, 0xff, 0x72, 0x07, 0xe5, 0xfb, 0x22, 0x00, 0x00, 0x00, /*   oX+ XX.    */
0x00, 0x00, 0x15, 0xf1, 0xe7, 0x6c, 0xff, 0xa1, 0x00, 0x00, 0x00, 0x00, /*    XX+Xa     */
0x00, 0x00, 0x00, 0x76, 0xff, 0xfb, 0xfe, 0x2b, 0x00, 0x00, 0x00, 0x00, /*    +XXX.     */
0x00, 0x00, 0x00, 0x07, 0xe1, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXa      */
0x00, 0x00, 0x00, 0x01, 0xd2, 0xff, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OX.      */
0x00, 0x00, 0x00, 0x53, 0xff, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -Xa       */
0x00, 0x00, 0x01, 0xd0, 0xff, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OX.       */
0x00, 0x00, 0x51, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -Xa        */
0x00, 0x00, 0xaa, 0xff, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aX.        */
0x00, 0x00, 0x31, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .-         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 90 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x7a, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa5, 0x00, /*  +XXXXXXXXa  */
0x00, 0x40, 0x8f, 0x90, 0x90, 0x90, 0x90, 0x94, 0xfb, 0xff, 0x7e, 0x00, /*  -ooooooXX+  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x89, 0xff, 0xac, 0x00, 0x00, /*        oXa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xfe, 0xeb, 0x14, 0x00, 0x00, /*       -XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe2, 0xff, 0x54, 0x00, 0x00, 0x00, /*       XX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa3, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, /*      aXa     */
0x00, 0x00, 0x00, 0x00, 0x51, 0xff, 0xe5, 0x11, 0x00, 0x00, 0x00, 0x00, /*     -XX      */
0x00, 0x00, 0x00, 0x14, 0xe9, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX-      */
0x00, 0x00, 0x00, 0xa7, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXo       */
0x00, 0x00, 0x4d, 0xff, 0xe1, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -XX        */
0x00, 0x0a, 0xe2, 0xff, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX-        */
0x00, 0x78, 0xff, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  +Xa         */
0x00, 0xe3, 0xff, 0xb1, 0x90, 0x90, 0x90, 0x8e, 0x8a, 0x7d, 0x49, 0x00, /*  XXaooooo+-  */
0x00, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, /*  aXXXXXXXXO  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 91 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x06, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa5, 0x00, 0x00, 0x00, /*   OXXXXXa    */
0x00, 0x01, 0xff, 0xf9, 0x92, 0x95, 0x9e, 0xb1, 0x6f, 0x00, 0x00, 0x00, /*   XXoooa+    */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x04, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x0b, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XX         */
0x00, 0x1d, 0xff, 0xf9, 0x90, 0x90, 0x90, 0x90, 0x57, 0x00, 0x00, 0x00, /*   XXoooo-    */
0x00, 0x17, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, /*   XXXXXXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x06, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 92 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x67, 0xe9, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +X.          */
0x6b, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +Xa          */
0x07, 0xde, 0xff, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OX.         */
0x00, 0x53, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -Xa         */
0x00, 0x00, 0xbe, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aX-        */
0x00, 0x00, 0x2b, 0xfb, 0xd1, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .XO        */
0x00, 0x00, 0x00, 0x90, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oX+       */
0x00, 0x00, 0x00, 0x0f, 0xe9, 0xe5, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +Xo      */
0x00, 0x00, 0x00, 0x00, 0x01, 0xcb, 0xf6, 0x1e, 0x00, 0x00, 0x00, 0x00, /*      OX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, /*      .Xa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb3, 0xff, 0x40, 0x00, 0x00, 0x00, /*       aX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xd3, 0x04, 0x00, 0x00, /*       .XO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0x70, 0x00, 0x00, /*        aX+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xff, 0xd4, 0x00, 0x00, /*        .XO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x78, 0x00, 0x00, /*         ++   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 93 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 0x00, 0x00, 0x00, /*   oXXXXXO    */
0x00, 0x00, 0x6d, 0xb1, 0x9e, 0x95, 0x92, 0xff, 0xf1, 0x00, 0x00, 0x00, /*   +aoooXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfb, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x6c, 0x90, 0x90, 0x90, 0x90, 0xff, 0xff, 0x0c, 0x00, 0x00, /*   +ooooXX    */
0x00, 0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xeb, 0x0f, 0x00, 0x00, /*   XXXXXXX    */
0x00, 0x00, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 94 */
0x00, 0x00, 0x00, 0x00, 0x0b, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x0d, 0xd5, 0xf9, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OX.      */
0x00, 0x00, 0x01, 0xae, 0xff, 0xff, 0xe2, 0x14, 0x00, 0x00, 0x00, 0x00, /*    aXXX      */
0x00, 0x00, 0x80, 0xff, 0xe6, 0xa0, 0xff, 0xbf, 0x05, 0x00, 0x00, 0x00, /*   oXXaXa     */
0x00, 0x5b, 0xff, 0xf6, 0x3b, 0x06, 0xc8, 0xff, 0xa9, 0x02, 0x00, 0x00, /*  -XX. OXa    */
0x37, 0xf8, 0xf7, 0x46, 0x00, 0x00, 0x15, 0xd9, 0xff, 0x99, 0x00, 0x00, /* .XX-   OXo   */
0xae, 0xfb, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xde, 0xfc, 0x0f, 0x00, /* aX-     OX   */
0x30, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x3e, 0x00, 0x00, /* .-       .   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 95 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x6a, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x6c, 0x00, 0x00, /*  +ooooooo+   */
0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5, 0x00, 0x00, /*  OXXXXXXXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 96 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x1c, 0x89, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    o.        */
0x00, 0x00, 0x56, 0xff, 0xed, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -XX-       */
0x00, 0x00, 0x01, 0x79, 0xf8, 0xfe, 0x90, 0x01, 0x00, 0x00, 0x00, 0x00, /*    +XXo      */
0x00, 0x00, 0x00, 0x00, 0x23, 0xaa, 0xe5, 0x16, 0x00, 0x00, 0x00, 0x00, /*     .aX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 97 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x53, 0xbf, 0xf0, 0xf7, 0xc9, 0x43, 0x00, 0x00, 0x00, /*    -aXXO-    */
0x00, 0x00, 0x87, 0xff, 0xed, 0x9e, 0xbd, 0xff, 0xfb, 0x30, 0x00, 0x00, /*   oXXoaXX.   */
0x00, 0x39, 0xff, 0xdc, 0x18, 0x00, 0x00, 0xc3, 0xff, 0x30, 0x00, 0x00, /*  .XO   OX.   */
0x00, 0x9e, 0xff, 0x52, 0x00, 0x00, 0x00, 0xcd, 0xff, 0x16, 0x00, 0x00, /*  oX-   OX    */
0x00, 0xdb, 0xff, 0x13, 0x00, 0x00, 0x00, 0xdd, 0xff, 0x09, 0x00, 0x00, /*  OX    OX    */
0x00, 0xf3, 0xf7, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0x03, 0x00, 0x00, /*  XX    XX    */
0x00, 0xf3, 0xff, 0x0d, 0x00, 0x00, 0x46, 0xff, 0xff, 0x13, 0x00, 0x00, /*  XX   -XX    */
0x00, 0xb8, 0xff, 0x62, 0x00, 0x14, 0xd9, 0xff, 0xff, 0x2f, 0x00, 0x00, /*  aX+  OXX.   */
0x00, 0x38, 0xfa, 0xf2, 0x9f, 0xe4, 0xe9, 0xbe, 0xff, 0x5d, 0x00, 0x00, /*  .XXoXXaX-   */
0x00, 0x00, 0x45, 0xcd, 0xf5, 0xc1, 0x2a, 0x71, 0xff, 0x7b, 0x00, 0x00, /*   -OXO.+X+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x42, 0x0b, 0x00, 0x00, /*         -    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 98 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xce, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  Oa          */
0x00, 0xff, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf2, 0x6a, 0xcc, 0xf1, 0xec, 0xa9, 0x20, 0x00, 0x00, 0x00, /*  XX+OXXa.    */
0x00, 0xff, 0xff, 0xfe, 0xc1, 0x9b, 0xd6, 0xff, 0xe8, 0x16, 0x00, 0x00, /*  XXXOoOXX    */
0x00, 0xff, 0xf8, 0x38, 0x00, 0x00, 0x04, 0xba, 0xff, 0x8d, 0x00, 0x00, /*  XX.   aXo   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xd3, 0x00, 0x00, /*  XX    .XO   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xe9, 0x00, 0x00, /*  XX     XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x17, 0xff, 0xd4, 0x00, 0x00, /*  XX     XO   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4d, 0xff, 0xb1, 0x00, 0x00, /*  XX    -Xa   */
0x00, 0xff, 0xf5, 0x14, 0x00, 0x00, 0x0f, 0xcd, 0xff, 0x59, 0x00, 0x00, /*  XX    OX-   */
0x00, 0xff, 0xff, 0xed, 0xa9, 0xa0, 0xe2, 0xff, 0xab, 0x01, 0x00, 0x00, /*  XXXaaXXa    */
0x00, 0xcd, 0xb2, 0x76, 0xd3, 0xf4, 0xdf, 0x7e, 0x07, 0x00, 0x00, 0x00, /*  Oa+OXO+     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 99 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x2c, 0xa7, 0xe2, 0xf2, 0xa8, 0x13, 0x00, 0x00, 0x00, /*    .aXXa     */
0x00, 0x00, 0x4e, 0xfa, 0xf2, 0xa0, 0xc1, 0xff, 0xbe, 0x00, 0x00, 0x00, /*   -XXaOXa    */
0x00, 0x22, 0xf8, 0xe5, 0x21, 0x00, 0x06, 0xeb, 0xff, 0x29, 0x00, 0x00, /*  .XX.  XX.   */
0x00, 0x8f, 0xff, 0x5d, 0x00, 0x00, 0x00, 0x62, 0xa4, 0x0b, 0x00, 0x00, /*  oX-   +a    */
0x00, 0xd4, 0xff, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OX          */
0x00, 0xf6, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xf5, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x11, 0x00, 0x00, /*  XX     .    */
0x00, 0xb3, 0xff, 0x71, 0x00, 0x00, 0x00, 0x4c, 0xff, 0x93, 0x00, 0x00, /*  aX+   -Xo   */
0x00, 0x27, 0xf4, 0xfe, 0xb5, 0x96, 0xb9, 0xfc, 0xf6, 0x36, 0x00, 0x00, /*  .XXaoaXX.   */
0x00, 0x00, 0x23, 0xb2, 0xf2, 0xf5, 0xdd, 0xa0, 0x26, 0x00, 0x00, 0x00, /*   .aXXOa.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 100 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xbd, 0x00, 0x00, /*         aa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xef, 0x00, 0x00, /*         XX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf7, 0xf0, 0x00, 0x00, /*         XX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfd, 0xf0, 0x00, 0x00, /*         XX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*         XX   */
0x00, 0x00, 0x21, 0xa7, 0xeb, 0xf3, 0xd1, 0x76, 0xff, 0xf0, 0x00, 0x00, /*   .aXXO+XX   */
0x00, 0x1a, 0xe9, 0xff, 0xce, 0x9a, 0xd6, 0xff, 0xff, 0xf0, 0x00, 0x00, /*   XXOoOXXX   */
0x00, 0x9a, 0xff, 0xa7, 0x01, 0x00, 0x03, 0x9d, 0xff, 0xf0, 0x00, 0x00, /*  oXa   oXX   */
0x00, 0xe3, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xf9, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, /*  XX     XX   */
0x00, 0xe3, 0xfe, 0x07, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, /*  XX     XX   */
0x00, 0xbd, 0xff, 0x37, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xfd, 0x00, 0x00, /*  aX.    XX   */
0x00, 0x62, 0xff, 0xb5, 0x04, 0x00, 0x00, 0x97, 0xff, 0xff, 0x10, 0x00, /*  +Xa   oXX   */
0x00, 0x03, 0xb2, 0xff, 0xd4, 0x99, 0xc3, 0xf3, 0xf9, 0xff, 0x3a, 0x00, /*   aXOoOXXX.  */
0x00, 0x00, 0x08, 0x80, 0xdf, 0xf6, 0xc5, 0x37, 0xa8, 0xf0, 0x2b, 0x00, /*    oOXO.aX.  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 101 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x01, 0x63, 0xca, 0xf6, 0xe6, 0x84, 0x07, 0x00, 0x00, 0x00, /*    +OXXo     */
0x00, 0x01, 0xa4, 0xff, 0xd8, 0x9a, 0xd4, 0xff, 0xc1, 0x06, 0x00, 0x00, /*   aXOoOXO    */
0x00, 0x5c, 0xff, 0xb5, 0x05, 0x00, 0x07, 0xc9, 0xff, 0x58, 0x00, 0x00, /*  -Xa   OX-   */
0x00, 0xc2, 0xff, 0x2b, 0x00, 0x0f, 0x6b, 0xe8, 0xf1, 0x1f, 0x00, 0x00, /*  OX.  +XX    */
0x00, 0xf1, 0xfd, 0x79, 0xba, 0xf9, 0xff, 0xbf, 0x2d, 0x00, 0x00, 0x00, /*  XX+aXXa.    */
0x00, 0xfa, 0xff, 0xff, 0xea, 0x92, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXo.      */
0x00, 0xdf, 0xff, 0x4b, 0x03, 0x00, 0x00, 0x00, 0x42, 0x19, 0x00, 0x00, /*  OX-    -    */
0x00, 0x9b, 0xff, 0x63, 0x00, 0x00, 0x02, 0x77, 0xff, 0xa0, 0x00, 0x00, /*  oX+   +Xa   */
0x00, 0x20, 0xf0, 0xfd, 0xae, 0x9d, 0xdb, 0xff, 0xf6, 0x35, 0x00, 0x00, /*  .XXaoOXX.   */
0x00, 0x00, 0x2d, 0xb7, 0xf4, 0xf7, 0xe1, 0xa4, 0x2c, 0x00, 0x00, 0x00, /*   .aXXXa.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 102 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x07, 0x73, 0xcc, 0xf0, 0xd0, 0x00, 0x00, 0x00, /*      +OXO    */
0x00, 0x00, 0x00, 0x11, 0xcc, 0xff, 0xf2, 0xb2, 0x6c, 0x00, 0x00, 0x00, /*     OXXa+    */
0x00, 0x00, 0x00, 0x91, 0xff, 0xce, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXO       */
0x00, 0x00, 0x00, 0xe2, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX.       */
0x00, 0x00, 0x00, 0xfd, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x62, 0x90, 0xff, 0xf9, 0x90, 0x90, 0x90, 0x72, 0x00, 0x00, 0x00, /*  +oXXooo+    */
0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd3, 0x00, 0x00, 0x00, /*  OXXXXXXO    */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xea, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x68, 0x90, 0xe8, 0xfa, 0x9d, 0x93, 0x68, 0x00, 0x00, 0x00, 0x00, /*  +oXXoo+     */
0x00, 0xcb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x00, 0x00, 0x00, 0x00, /*  OXXXXXO     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 103 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x01, 0x61, 0xc6, 0xef, 0xfc, 0xdd, 0x4f, 0x00, 0x00, 0x00, /*    +OXXO-    */
0x00, 0x02, 0xa3, 0xff, 0xdb, 0x99, 0xaf, 0xf6, 0xa9, 0x00, 0x00, 0x00, /*   aXOoaXa    */
0x00, 0x62, 0xff, 0xb7, 0x06, 0x00, 0x00, 0xec, 0xfd, 0x00, 0x00, 0x00, /*  +Xa   XX    */
0x00, 0xc3, 0xff, 0x28, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  OX.   XX    */
0x00, 0xf2, 0xf7, 0x01, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xfc, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xed, 0xfd, 0x05, 0x00, 0x00, 0x17, 0xfe, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xc1, 0xff, 0x4d, 0x00, 0x00, 0x97, 0xff, 0xff, 0x00, 0x00, 0x00, /*  OX-  oXX    */
0x00, 0x62, 0xff, 0xee, 0x9e, 0xc7, 0xfa, 0xff, 0xfe, 0x00, 0x00, 0x00, /*  +XXoOXXX    */
0x00, 0x00, 0x80, 0xe8, 0xf9, 0xce, 0x51, 0xff, 0xf9, 0x00, 0x00, 0x00, /*   oXXO-XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xff, 0xeb, 0x00, 0x00, 0x00, /*       .XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xc7, 0x00, 0x00, 0x00, /*       -XO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xcd, 0xff, 0x78, 0x00, 0x00, 0x00, /*       OX+    */
0x04, 0x11, 0x00, 0x00, 0x08, 0xa3, 0xff, 0xd6, 0x09, 0x00, 0x00, 0x00, /*      aXO     */
0x73, 0xf7, 0xa8, 0xa2, 0xe9, 0xff, 0xdb, 0x27, 0x00, 0x00, 0x00, 0x00, /* +XaaXXO.     */
0x20, 0x9d, 0xe5, 0xf6, 0xd6, 0x7e, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, /* .oXXO+       */
	/* 104 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xca, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  Oa          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x11, 0x8c, 0xda, 0xf7, 0xcf, 0x19, 0x00, 0x00, 0x00, /*  XX oOXO     */
0x00, 0xff, 0xf5, 0xd6, 0xf0, 0xa6, 0xd5, 0xff, 0xa3, 0x00, 0x00, 0x00, /*  XXOXaOXa    */
0x00, 0xff, 0xff, 0xe1, 0x1b, 0x00, 0x2e, 0xff, 0xe5, 0x00, 0x00, 0x00, /*  XXX  .XX    */
0x00, 0xff, 0xff, 0x59, 0x00, 0x00, 0x01, 0xfb, 0xfb, 0x00, 0x00, 0x00, /*  XX-   XX    */
0x00, 0xff, 0xfd, 0x0d, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x02, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x09, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x05, 0xdb, 0x9e, 0x00, 0x00, 0x00, 0x00, 0xb5, 0xbe, 0x00, 0x00, 0x00, /*  Oo    aa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 105 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x84, 0xf4, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXo      */
0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXX      */
0x00, 0x00, 0x00, 0x00, 0x81, 0xe4, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oX+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x06, 0x7f, 0x90, 0x90, 0x8f, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +ooo-      */
0x00, 0x1a, 0xf2, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXXXX      */
0x00, 0x00, 0x00, 0x00, 0x04, 0xfe, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x7c, 0xa0, 0xa0, 0xa0, 0xff, 0xfa, 0xa0, 0xa0, 0x82, 0x00, 0x00, /*  +aaaXXaao   */
0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd3, 0x00, 0x00, /*  OXXXXXXXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 106 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9b, 0xf5, 0x8d, 0x00, 0x00, 0x00, /*       oXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xf3, 0x00, 0x00, 0x00, /*       XXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xeb, 0x82, 0x00, 0x00, 0x00, /*       +Xo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x12, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd3, 0x04, 0x00, 0x00, /*   XXXXXXO    */
0x00, 0x01, 0x72, 0x90, 0x90, 0x90, 0x90, 0xff, 0xff, 0x0d, 0x00, 0x00, /*   +ooooXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf2, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xef, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xdd, 0x00, 0x00, 0x00, /*        XO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0xff, 0xb1, 0x00, 0x00, 0x00, /*       oXa    */
0x00, 0x00, 0x00, 0x00, 0x05, 0x74, 0xfb, 0xfe, 0x40, 0x00, 0x00, 0x00, /*      +XX-    */
0x00, 0x1d, 0x91, 0xad, 0xed, 0xff, 0xf8, 0x68, 0x00, 0x00, 0x00, 0x00, /*   oaXXX+     */
0x00, 0x5a, 0xf8, 0xf1, 0xca, 0x86, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXOo.      */
	/* 107 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xc5, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  Oa          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x5b, 0x00, 0x00, 0x00, /*  XX    --    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x79, 0xfe, 0xb2, 0x00, 0x00, 0x00, /*  XX   +Xa    */
0x00, 0xff, 0xf0, 0x00, 0x04, 0x9c, 0xff, 0xd3, 0x17, 0x00, 0x00, 0x00, /*  XX  oXO     */
0x00, 0xff, 0xf0, 0x0c, 0xb9, 0xff, 0xc5, 0x11, 0x00, 0x00, 0x00, 0x00, /*  XX aXO      */
0x00, 0xff, 0xf5, 0xca, 0xff, 0xe6, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXOXX       */
0x00, 0xff, 0xff, 0xff, 0xe6, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXX-      */
0x00, 0xff, 0xfd, 0x75, 0x25, 0xf9, 0xf1, 0x23, 0x00, 0x00, 0x00, 0x00, /*  XX+.XX.     */
0x00, 0xff, 0xd3, 0x00, 0x00, 0x76, 0xff, 0xcd, 0x07, 0x00, 0x00, 0x00, /*  XO  +XO     */
0x03, 0xff, 0xda, 0x00, 0x00, 0x01, 0xb9, 0xff, 0x96, 0x00, 0x00, 0x00, /*  XO   aXo    */
0x0c, 0xff, 0xe9, 0x00, 0x00, 0x00, 0x12, 0xde, 0xff, 0x51, 0x00, 0x00, /*  XX    OX-   */
0x06, 0xdc, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x30, 0xf1, 0x6c, 0x00, 0x00, /*  Oa    .X+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 108 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x11, 0xec, 0xff, 0xff, 0xff, 0xe5, 0x07, 0x00, 0x00, 0x00, 0x00, /*   XXXXX      */
0x00, 0x01, 0x77, 0x8f, 0x8a, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +ooXX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x6a, 0x90, 0x90, 0x90, 0xff, 0xf9, 0x90, 0x90, 0x6b, 0x00, 0x00, /*  +oooXXoo+   */
0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00, /*  OXXXXXXXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 109 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xb6, 0xd6, 0x37, 0xcc, 0xf0, 0x36, 0x57, 0xe3, 0x97, 0x00, 0x00, /*  aO.OX.-Xo   */
0x00, 0xff, 0xf2, 0xed, 0xb6, 0xff, 0xca, 0xd1, 0xff, 0xe1, 0x00, 0x00, /*  XXXaXOOXX   */
0x00, 0xff, 0xff, 0x92, 0x07, 0xff, 0xff, 0x3a, 0xf6, 0xf3, 0x00, 0x00, /*  XXo XX.XX   */
0x00, 0xff, 0xfa, 0x16, 0x00, 0xff, 0xf7, 0x03, 0xf0, 0xfb, 0x00, 0x00, /*  XX  XX XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xf0, 0xff, 0x00, 0x00, /*  XX  XX XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xf0, 0xff, 0x00, 0x00, /*  XX  XX XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xf0, 0xff, 0x00, 0x00, /*  XX  XX XX   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xef, 0xff, 0x00, 0x00, /*  XX  XX XX   */
0x00, 0xff, 0xef, 0x00, 0x00, 0xff, 0xef, 0x00, 0xeb, 0xff, 0x00, 0x00, /*  XX  XX XX   */
0x00, 0xd2, 0xbe, 0x00, 0x00, 0xc1, 0xc5, 0x00, 0xad, 0xd5, 0x00, 0x00, /*  Oa  OO aO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 110 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xb8, 0xde, 0x23, 0xa3, 0xea, 0xf1, 0xaa, 0x0e, 0x00, 0x00, 0x00, /*  aO.aXXa     */
0x00, 0xff, 0xff, 0xe9, 0xf3, 0xa6, 0xc7, 0xff, 0x8f, 0x00, 0x00, 0x00, /*  XXXXaOXo    */
0x00, 0xff, 0xff, 0xdb, 0x1c, 0x00, 0x13, 0xff, 0xdf, 0x00, 0x00, 0x00, /*  XXO   XO    */
0x00, 0xff, 0xfe, 0x34, 0x00, 0x00, 0x00, 0xf6, 0xfa, 0x00, 0x00, 0x00, /*  XX.   XX    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xed, 0xff, 0x0a, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0x21, 0x00, 0x00, /*  XX    OX.   */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0x3f, 0x00, 0x00, /*  XX    OX.   */
0x00, 0xfa, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xa3, 0xff, 0x60, 0x00, 0x00, /*  XX    aX+   */
0x00, 0xee, 0xef, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x79, 0x00, 0x00, /*  XX    +X+   */
0x00, 0xb6, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xf1, 0x53, 0x00, 0x00, /*  aO    .X-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 111 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x08, 0x7c, 0xd8, 0xf8, 0xe1, 0x8e, 0x12, 0x00, 0x00, 0x00, /*    +OXXo     */
0x00, 0x01, 0xbe, 0xff, 0xc8, 0x9e, 0xd9, 0xff, 0xcb, 0x0b, 0x00, 0x00, /*   aXOoOXO    */
0x00, 0x5a, 0xff, 0xa2, 0x00, 0x00, 0x06, 0xb3, 0xff, 0x74, 0x00, 0x00, /*  -Xa   aX+   */
0x00, 0xc6, 0xff, 0x2b, 0x00, 0x00, 0x00, 0x36, 0xff, 0xbc, 0x00, 0x00, /*  OX.   .Xa   */
0x00, 0xf3, 0xfd, 0x03, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xd8, 0x00, 0x00, /*  XX     XO   */
0x00, 0xf9, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xea, 0x00, 0x00, /*  XX     XX   */
0x00, 0xd4, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0x36, 0xff, 0xd5, 0x00, 0x00, /*  OX    .XO   */
0x00, 0x71, 0xff, 0x7b, 0x00, 0x00, 0x02, 0xad, 0xff, 0x8e, 0x00, 0x00, /*  +X+   aXo   */
0x00, 0x07, 0xd5, 0xff, 0xc3, 0x9b, 0xcf, 0xff, 0xe3, 0x16, 0x00, 0x00, /*   OXOoOXX    */
0x00, 0x00, 0x14, 0x9b, 0xeb, 0xfa, 0xe0, 0x99, 0x1a, 0x00, 0x00, 0x00, /*    oXXXo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 112 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x76, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  +o          */
0x00, 0xf1, 0xdc, 0x7b, 0xda, 0xf6, 0xd3, 0x52, 0x00, 0x00, 0x00, 0x00, /*  XO+OXO-     */
0x00, 0xfe, 0xff, 0xff, 0xbb, 0x9c, 0xf3, 0xfb, 0x36, 0x00, 0x00, 0x00, /*  XXXaoXX.    */
0x00, 0xff, 0xfa, 0x46, 0x00, 0x00, 0x5d, 0xff, 0xa3, 0x00, 0x00, 0x00, /*  XX-  -Xa    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xda, 0x00, 0x00, 0x00, /*  XX    XO    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf7, 0xf5, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0xfd, 0xf9, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x28, 0xff, 0xd8, 0x00, 0x00, 0x00, /*  XX   .XO    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x87, 0x00, 0x00, 0x00, /*  XX   oXo    */
0x00, 0xff, 0xfa, 0x9c, 0x90, 0xa9, 0xfe, 0xe5, 0x12, 0x00, 0x00, 0x00, /*  XXooaXX     */
0x00, 0xff, 0xfc, 0xde, 0xf7, 0xf9, 0xbd, 0x22, 0x00, 0x00, 0x00, 0x00, /*  XXOXXa.     */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xc0, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  Oa          */
	/* 113 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x53, 0xbc, 0xea, 0xf8, 0xd2, 0x6c, 0x01, 0x00, 0x00, /*    -aXXO+    */
0x00, 0x00, 0x8e, 0xff, 0xe2, 0x98, 0xab, 0xfd, 0xff, 0x63, 0x00, 0x00, /*   oXXoaXX+   */
0x00, 0x4d, 0xff, 0xc8, 0x0c, 0x00, 0x00, 0xf0, 0xff, 0x19, 0x00, 0x00, /*  -XO   XX    */
0x00, 0xb1, 0xff, 0x3d, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  aX.   XX    */
0x00, 0xe8, 0xfd, 0x07, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xfb, 0xf9, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xe6, 0xff, 0x1e, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0x9d, 0xff, 0x86, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  oXo   XX    */
0x00, 0x1f, 0xee, 0xfd, 0xaa, 0x9c, 0xc9, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXaoOXX    */
0x00, 0x00, 0x2a, 0xbc, 0xf8, 0xf3, 0xca, 0xfa, 0xff, 0x00, 0x00, 0x00, /*   .aXXOXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 0xff, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfd, 0xfd, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xf1, 0x00, 0x00, 0x00, /*        XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd5, 0x9c, 0x00, 0x00, 0x00, /*        Oo    */
	/* 114 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xb5, 0xca, 0x00, 0x1f, 0x80, 0xca, 0xe9, 0xa8, 0x00, 0x00, 0x00, /*  aO  oOXa    */
0x00, 0xf0, 0xfe, 0x64, 0xf5, 0xfc, 0xd9, 0xff, 0xec, 0x00, 0x00, 0x00, /*  XX+XXOXX    */
0x00, 0xf4, 0xff, 0xfd, 0xb6, 0x1f, 0x00, 0xf0, 0xf7, 0x00, 0x00, 0x00, /*  XXXa  XX    */
0x00, 0xf7, 0xff, 0xb5, 0x03, 0x00, 0x00, 0xa4, 0x9e, 0x00, 0x00, 0x00, /*  XXa   ao    */
0x00, 0xfb, 0xff, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xfe, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xf7, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XX          */
0x00, 0xdf, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OX          */
0x00, 0xa1, 0xc9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aO          */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 115 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x18, 0x77, 0xb8, 0xde, 0xf4, 0xf6, 0x1e, 0x00, 0x00, 0x00, /*    +aOXX     */
0x00, 0x49, 0xf2, 0xff, 0xd9, 0xa5, 0xc5, 0xff, 0x68, 0x00, 0x00, 0x00, /*  -XXOaOX+    */
0x00, 0xe0, 0xfb, 0x45, 0x00, 0x00, 0x33, 0xff, 0x7f, 0x00, 0x00, 0x00, /*  XX-  .X+    */
0x00, 0xee, 0xfc, 0x84, 0x3a, 0x07, 0x00, 0x40, 0x11, 0x00, 0x00, 0x00, /*  XXo.  -     */
0x00, 0x51, 0xde, 0xff, 0xff, 0xf9, 0xbf, 0x61, 0x04, 0x00, 0x00, 0x00, /*  -OXXXa+     */
0x00, 0x00, 0x01, 0x30, 0x70, 0xac, 0xef, 0xff, 0xbb, 0x01, 0x00, 0x00, /*    .+aXXa    */
0x03, 0x2f, 0x01, 0x00, 0x00, 0x00, 0x0a, 0xdd, 0xff, 0x18, 0x00, 0x00, /*  .     OX    */
0x66, 0xff, 0x7b, 0x00, 0x00, 0x08, 0x78, 0xfe, 0xd4, 0x00, 0x00, 0x00, /* +X+   +XO    */
0x42, 0xff, 0xf9, 0xa2, 0xa7, 0xe7, 0xff, 0xe9, 0x31, 0x00, 0x00, 0x00, /* -XXaaXXX.    */
0x00, 0x55, 0xce, 0xf6, 0xf3, 0xce, 0x83, 0x16, 0x00, 0x00, 0x00, 0x00, /*  -OXXOo      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 116 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x0a, 0xeb, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    Xo        */
0x00, 0x00, 0x1b, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x10, 0xff, 0xed, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x06, 0xff, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0xd1, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 0x00, 0x00, 0x00, /*  OXXXXXXO    */
0x00, 0x6b, 0x90, 0xf6, 0xf9, 0x90, 0x90, 0x90, 0x71, 0x00, 0x00, 0x00, /*  +oXXooo+    */
0x00, 0x00, 0x00, 0xf9, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xfd, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XX        */
0x00, 0x00, 0x00, 0xdc, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, /*    OX.       */
0x00, 0x00, 0x00, 0x5b, 0xff, 0xf2, 0xa0, 0xa0, 0xd5, 0xd9, 0x00, 0x00, /*    -XXaaOO   */
0x00, 0x00, 0x00, 0x00, 0x58, 0xce, 0xf7, 0xef, 0xc4, 0x55, 0x00, 0x00, /*     -OXXO-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 117 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xcd, 0xb7, 0x00, 0x00, 0x00, 0x00, 0xb7, 0xb3, 0x00, 0x00, 0x00, /*  Oa    aa    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xfb, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xff, 0xff, 0x07, 0x00, 0x00, 0x03, 0xf2, 0xff, 0x00, 0x00, 0x00, /*  XX    XX    */
0x00, 0xf1, 0xff, 0x37, 0x00, 0x33, 0xc9, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XX. .OXX    */
0x00, 0x8d, 0xff, 0xf7, 0xeb, 0xff, 0xd0, 0xfb, 0xff, 0x00, 0x00, 0x00, /*  oXXXXOXX    */
0x00, 0x04, 0x96, 0xe0, 0xc7, 0x6a, 0x07, 0xc3, 0xcd, 0x00, 0x00, 0x00, /*   oXO+ OO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 118 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x05, 0x00, 0x00, /*              */
0x28, 0xeb, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xc0, 0x00, 0x00, /* .X+     aO   */
0x3b, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xc2, 0x00, 0x00, /* .XO    .XO   */
0x01, 0xdb, 0xff, 0x30, 0x00, 0x00, 0x00, 0x81, 0xff, 0x69, 0x00, 0x00, /*  OX.   oX+   */
0x00, 0x72, 0xff, 0x8f, 0x00, 0x00, 0x03, 0xe4, 0xf2, 0x0f, 0x00, 0x00, /*  +Xo   XX    */
0x00, 0x11, 0xf6, 0xec, 0x07, 0x00, 0x55, 0xff, 0x8c, 0x00, 0x00, 0x00, /*   XX  -Xo    */
0x00, 0x00, 0x99, 0xff, 0x5f, 0x00, 0xc8, 0xf9, 0x1b, 0x00, 0x00, 0x00, /*   oX- OX     */
0x00, 0x00, 0x22, 0xfb, 0xcb, 0x45, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, /*   .XO-Xo     */
0x00, 0x00, 0x00, 0x9f, 0xff, 0xe1, 0xfd, 0x26, 0x00, 0x00, 0x00, 0x00, /*    oXXX.     */
0x00, 0x00, 0x00, 0x24, 0xfc, 0xff, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XXa      */
0x00, 0x00, 0x00, 0x00, 0x99, 0xfa, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oX.      */
0x00, 0x00, 0x00, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 119 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x0b, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, /*              */
0xc5, 0xdf, 0x00, 0x00, 0x65, 0xec, 0x2f, 0x00, 0x4d, 0xfd, 0x2c, 0x00, /* OO  +X. -X.  */
0xc2, 0xff, 0x0b, 0x00, 0xc7, 0xff, 0x73, 0x00, 0x76, 0xff, 0x32, 0x00, /* OX  OX+ +X.  */
0xa4, 0xff, 0x2b, 0x06, 0xf8, 0xfc, 0x9d, 0x00, 0x95, 0xff, 0x0e, 0x00, /* aX. XXo oX   */
0x7b, 0xff, 0x4d, 0x31, 0xff, 0xb9, 0xca, 0x00, 0xb4, 0xe7, 0x00, 0x00, /* +X-.XaO aX   */
0x4c, 0xff, 0x73, 0x63, 0xdf, 0x85, 0xf5, 0x02, 0xd5, 0xbc, 0x00, 0x00, /* -X++OoX Oa   */
0x15, 0xff, 0x9a, 0x92, 0xab, 0x64, 0xff, 0x29, 0xf5, 0x90, 0x00, 0x00, /*  Xooa+X.Xo   */
0x00, 0xd9, 0xc4, 0xc2, 0x76, 0x40, 0xff, 0x77, 0xff, 0x5e, 0x00, 0x00, /*  OOO+-X+X-   */
0x00, 0x97, 0xee, 0xf1, 0x3b, 0x14, 0xff, 0xda, 0xff, 0x27, 0x00, 0x00, /*  oXX. XOX.   */
0x00, 0x50, 0xff, 0xf1, 0x04, 0x00, 0xd6, 0xff, 0xe7, 0x00, 0x00, 0x00, /*  -XX  OXX    */
0x00, 0x0a, 0xd5, 0x91, 0x00, 0x00, 0x66, 0xf1, 0x75, 0x00, 0x00, 0x00, /*   Oo  +X+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 120 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x86, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xac, 0x2a, 0x00, 0x00, /*  o-     a.   */
0x02, 0xec, 0xff, 0x5f, 0x00, 0x00, 0x0c, 0xd5, 0xff, 0x43, 0x00, 0x00, /*  XX-   OX-   */
0x00, 0x4d, 0xfb, 0xf9, 0x39, 0x00, 0xa4, 0xff, 0x91, 0x00, 0x00, 0x00, /*  -XX. aXo    */
0x00, 0x00, 0x5c, 0xfe, 0xe5, 0x75, 0xff, 0xc0, 0x04, 0x00, 0x00, 0x00, /*   -XX+XO     */
0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xe3, 0x16, 0x00, 0x00, 0x00, 0x00, /*    +XXX      */
0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XXo      */
0x00, 0x00, 0x35, 0xf4, 0xec, 0xd9, 0xfe, 0x51, 0x00, 0x00, 0x00, 0x00, /*   .XXOX-     */
0x00, 0x2d, 0xed, 0xfa, 0x41, 0x26, 0xef, 0xf7, 0x41, 0x00, 0x00, 0x00, /*  .XX-.XX-    */
0x17, 0xe6, 0xff, 0x65, 0x00, 0x00, 0x44, 0xfa, 0xf1, 0x2a, 0x00, 0x00, /*  XX+  -XX.   */
0x67, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x5d, 0xfe, 0xa3, 0x00, 0x00, /* +Xo    -Xa   */
0x0e, 0x5d, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x2a, 0x00, 0x00, /*  -      ..   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 121 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x3d, 0xd7, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xe0, 0x0c, 0x00, /* .O.     oX   */
0x63, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x11, 0xf7, 0xfa, 0x0f, 0x00, /* +Xa     XX   */
0x15, 0xfa, 0xf4, 0x0c, 0x00, 0x00, 0x00, 0x71, 0xff, 0xa5, 0x00, 0x00, /*  XX    +Xa   */
0x00, 0xaa, 0xff, 0x63, 0x00, 0x00, 0x02, 0xdd, 0xff, 0x32, 0x00, 0x00, /*  aX+   OX.   */
0x00, 0x3c, 0xff, 0xcd, 0x00, 0x00, 0x53, 0xff, 0xba, 0x00, 0x00, 0x00, /*  .XO  -Xa    */
0x00, 0x00, 0xc9, 0xff, 0x3d, 0x00, 0xc8, 0xff, 0x3f, 0x00, 0x00, 0x00, /*   OX. OX.    */
0x00, 0x00, 0x51, 0xff, 0xb4, 0x42, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, /*   -Xa-XO     */
0x00, 0x00, 0x01, 0xd4, 0xff, 0xd6, 0xff, 0x47, 0x00, 0x00, 0x00, 0x00, /*    OXOX-     */
0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xc9, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XXO      */
0x00, 0x00, 0x00, 0x01, 0xe4, 0xff, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX-      */
0x00, 0x00, 0x00, 0x39, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XO       */
0x00, 0x00, 0x00, 0xba, 0xff, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aX-       */
0x00, 0x00, 0x3b, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .XO        */
0x00, 0x00, 0xbd, 0xff, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aX-        */
0x00, 0x35, 0xff, 0xcf, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .XO         */
0x00, 0x2d, 0xe1, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .X-         */
	/* 122 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0xc0, 0xda, 0xc5, 0xb1, 0xa2, 0x9b, 0x94, 0x61, 0x00, 0x00, 0x00, /*  OOOaaoo+    */
0x00, 0x97, 0xda, 0xed, 0xf8, 0xfd, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, /*  oOXXXXXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0x85, 0x00, 0x00, 0x00, /*       oXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xff, 0xc9, 0x06, 0x00, 0x00, 0x00, /*      +XO     */
0x00, 0x00, 0x00, 0x00, 0x6d, 0xff, 0xe2, 0x1d, 0x00, 0x00, 0x00, 0x00, /*     +XX      */
0x00, 0x00, 0x00, 0x64, 0xfe, 0xe4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +XX.      */
0x00, 0x00, 0x5f, 0xfd, 0xd8, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -XO        */
0x00, 0x51, 0xfc, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XO         */
0x1c, 0xf5, 0xff, 0xa1, 0x8c, 0x87, 0x7d, 0x6d, 0x3c, 0x00, 0x00, 0x00, /*  XXaoo++.    */
0x18, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, /*  XXXXXXXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 123 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xa7, 0xe7, 0xf6, 0x58, 0x00, 0x00, /*      .aXX-   */
0x00, 0x00, 0x00, 0x00, 0x38, 0xf6, 0xfe, 0xbd, 0x8d, 0x15, 0x00, 0x00, /*     .XXao    */
0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OX-      */
0x00, 0x00, 0x00, 0x00, 0xf8, 0xfa, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aX+      */
0x00, 0x00, 0x00, 0x00, 0x2b, 0xfe, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XX      */
0x00, 0x00, 0x00, 0x0e, 0x54, 0xfe, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -Xa      */
0x00, 0xd3, 0xff, 0xff, 0xe1, 0x5d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXXX-       */
0x00, 0x58, 0x99, 0xb9, 0xf5, 0xd2, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -oaXO.      */
0x00, 0x00, 0x00, 0x00, 0x12, 0xe1, 0xeb, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x06, 0xf1, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XO      */
0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -Xo      */
0x00, 0x00, 0x00, 0x00, 0xb9, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aX.      */
0x00, 0x00, 0x00, 0x00, 0xf0, 0xfb, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xec, 0xfd, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX.      */
0x00, 0x00, 0x00, 0x00, 0x68, 0xfe, 0xf8, 0xb4, 0x8c, 0x23, 0x00, 0x00, /*     +XXao.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xab, 0xe1, 0xf7, 0x55, 0x00, 0x00, /*      -aXX-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 124 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, /*      Oa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x06, 0xe0, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, /*      Xa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 125 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x56, 0xf7, 0xdf, 0xa7, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XOa-       */
0x00, 0x24, 0x8e, 0xb8, 0xf9, 0xff, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .oaXX+      */
0x00, 0x00, 0x00, 0x00, 0x39, 0xff, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XO      */
0x00, 0x00, 0x00, 0x00, 0x11, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XO      */
0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -Xo      */
0x00, 0x00, 0x00, 0x00, 0xad, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aX.      */
0x00, 0x00, 0x00, 0x00, 0xf3, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XO       */
0x00, 0x00, 0x00, 0x00, 0xc3, 0xec, 0x5e, 0x18, 0x02, 0x00, 0x00, 0x00, /*     OX-      */
0x00, 0x00, 0x00, 0x00, 0x07, 0x71, 0xe7, 0xff, 0xfb, 0x52, 0x00, 0x00, /*      +XXX-   */
0x00, 0x00, 0x00, 0x00, 0x36, 0xcb, 0xd5, 0x98, 0x8c, 0x25, 0x00, 0x00, /*     .OOoo.   */
0x00, 0x00, 0x00, 0x00, 0xe7, 0xf2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX       */
0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OX-      */
0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +Xa      */
0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XO      */
0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XX      */
0x00, 0x00, 0x00, 0x00, 0x6b, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +Xa      */
0x00, 0x17, 0x8e, 0xc0, 0xff, 0xef, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oOXX.      */
0x00, 0x56, 0xf6, 0xe6, 0xa2, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXa.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
	/* 126 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x1f, 0xbe, 0xf8, 0xa1, 0x02, 0x00, 0x00, 0x01, 0x37, 0x00, 0x00, /*   aXa    .   */
0x04, 0xd3, 0xef, 0xa6, 0xff, 0x64, 0x00, 0x00, 0x78, 0xec, 0x00, 0x00, /*  OXaX+  +X   */
0x52, 0xff, 0x6d, 0x00, 0xae, 0xdc, 0x04, 0x0c, 0xeb, 0xa7, 0x00, 0x00, /* -X+ aO  Xa   */
0x98, 0xf7, 0x13, 0x00, 0x27, 0xfa, 0xb6, 0xc2, 0xf4, 0x24, 0x00, 0x00, /* oX  .XaOX.   */
0x43, 0x41, 0x00, 0x00, 0x00, 0x5c, 0xec, 0xd9, 0x41, 0x00, 0x00, 0x00, /* --   -XO-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*              */
};
