#ifndef __YPBIND_H
#define __YPBIND_H

#include <config.h>
#ifndef _PATH_YPCONF
#define _PATH_YPCONF "/etc/yp.conf"
#endif
#ifndef _PATH_VARRUN
#ifdef SOLARIS
#define _PATH_VARRUN "/var/yp/binding/"
#else
#define _PATH_VARRUN "/var/run/"
#endif
#endif
#define _PATH_YPPIDFILE _PATH_VARRUN"ypbind.pid"
#define _MAXDOMAIN  4
#define _MAXSERVER  6
#define PING_INTERVAL     30 /* check binding every 30 seconds */
#define YPSET_NO	0
#define YPSET_LOCAL	1
#define YPSET_ALL	2

struct bound_server
{
  char *host;
  struct in_addr server_addr;
  unsigned short int server_port;
  long int version;
  bool_t use_broadcast;
  CLIENT *client_handle;
  bool_t filled;
};

struct binding
{
  char domain[YPMAXDOMAIN];
  bool_t is_bound;
  bool_t is_alive;
  int lockfd;
  int active; /* index into server */
  struct bound_server server[_MAXSERVER];
};

typedef char *domainname;

#if !defined(HAVE_RES_GETHOSTBYNAME)
#if defined(HAVE__DNS_GETHOSTBYNAME)
#define res_gethostbyname _dns_gethostbyname
extern struct hostent *_dns_gethostbyname(const char *);
#define res_gethostbyaddr _dns_gethostbyaddr
extern struct hostent *_dns_gethostbyaddr(const char *, int, int);
#else
/* !defined(HAVE_RES_GETHOSTBYNAME) && !defined(HAVE__DNS_GETHOSTBYNAME) */
#define res_gethostbyname gethostbyname
#define res_gethostbyaddr gethostbyaddr
#endif
#else
/* defined(HAVE_RES_GETHOSTBYNAME) */
extern struct hostent *res_gethostbyname(const char *);
extern struct hostent *res_gethostbyaddr(const char *, int, int);
#endif


extern void *ypbindproc_null_2_svc(struct svc_req *);
extern struct ypbind_resp *ypbindproc_domain_2_svc(domainname, struct svc_req *);
extern void *ypbindproc_setdom_2_svc(struct ypbind_setdom, struct svc_req *);
extern struct ypservers *ypconf_read(const char *);

extern bool_t xdr_domainname_ypbind(XDR *, char *);

bool_t eachresult(bool_t *, struct sockaddr_in *);
void parse_config_file(const char *);
void broadcast(struct binding *);
void add_server(char *, struct sockaddr_in *, CLIENT *, const char *, bool_t);
void sighandler(int);
void toggle_debug(int);
void handle_hangup(int);
void terminate(void);
int get_entry(char *, struct binding *);
void update_entry(struct binding *);
int open_lockfile(void);
struct binding *find_entry(char *dom);
pid_t start_slave (void);
void bindto_server (char *, char *);
void ping_server(struct binding *, int);
void write_lock_binding(void);
void read_lock_binding(void);
void un_lock_read_binding(void);
void un_lock_write_binding(void);
void inststr(char **, int, const char *);
void init_binding(void);
void check_binding(void);
void create_pidfile(void);
#if HAVE_IPC
void init_master_slave_communication(void);
void terminate_master_slave_communication(void);
#endif

/*
 * $Log: ypbind.h,v $
 * Revision 1.6  1997/05/20 16:52:48  swen
 * More changes for autoconf. Documentation updates. Added no-ping option.
 *
 * Revision 1.5  1997/02/17 18:08:36  swen
 * More modifications for autoconf.
 *
 * Revision 1.4  1997/02/17 09:18:13  swen
 * Started transformation to autoconf.
 *
 * Revision 1.3  1996/10/08 09:58:31  swen
 * Updated for release 3.0
 *
 * Revision 1.2  1995/11/15 10:06:31  swen
 * Added SYSV-IPC (from Michael Rausch <mrausch@ernie.mi.uni-koeln.de>)
 * Make mmap (not MAP_ANON) work again with latest kernels.
 *
 * Revision 1.1  1995/07/25  14:28:02  swen
 * ypbind version 2.0.
 *
 * Revision 2.4  1995/01/24  12:24:32  swen
 * Added RCS keywords.
 *
 */
#endif
